/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.TestRoutines;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectTest
extends BaseJDBCTestCase {
    public ConnectTest(String string) {
        super(string);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new BaseTestSuite("empty ConnectTest:DriverManager not supported");
        }
        BaseTestSuite baseTestSuite = new BaseTestSuite("ConnectTest suite");
        baseTestSuite.addTest(TestConfiguration.defaultSuite(ConnectTest.class));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator((Test)new ConnectTest("clientTestDerby2026LoginTimeout")));
        return new CleanDatabaseTestSetup((Test)baseTestSuite);
    }

    public void testConnectRepeatedly() throws SQLException {
        String string = "jdbc:derby:wombat;create=true";
        Connection connection = DriverManager.getConnection(string);
        Statement statement = connection.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("values 1"), "1");
        statement.close();
        connection.close();
        connection = DriverManager.getConnection(string);
        statement = connection.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("values 1"), "1");
        statement.close();
        connection.close();
    }

    public void testDBName() throws SQLException {
        String string = "jdbc:derby:wombat/seg0;create=true";
        try {
            DriverManager.getConnection(string);
            ConnectTest.fail((String)"Error XBM0J is expected");
        }
        catch (SQLException sQLException) {
            ConnectTest.assertEquals((String)"XJ041", (String)sQLException.getSQLState());
        }
        string = "jdbc:derby: ;databaseName=wombat";
        try {
            DriverManager.getConnection(string);
            ConnectTest.fail((String)"Error XJ004 is expected");
        }
        catch (SQLException sQLException) {
            ConnectTest.assertEquals((String)"XJ004", (String)sQLException.getSQLState());
        }
        string = "jdbc:derby:;databaseName=wombat";
        Connection connection = DriverManager.getConnection(string);
        connection.close();
    }

    public void testGrantAndRevoke() throws SQLException {
        String string = "jdbc:derby:wombat";
        Connection connection = DriverManager.getConnection(string);
        String string2 = "create table mytab(i int)";
        Statement statement = connection.createStatement();
        statement.execute(string2);
        string2 = "grant select on mytab to satheesh";
        try {
            statement.executeUpdate(string2);
            ConnectTest.fail((String)"Error 42Z60 is expected");
        }
        catch (SQLException sQLException) {
            ConnectTest.assertEquals((String)"42Z60", (String)sQLException.getSQLState());
        }
        string2 = "revoke select on mytab to satheesh";
        try {
            statement.executeUpdate(string2);
            ConnectTest.fail((String)"Error 42Z60 is expected");
        }
        catch (SQLException sQLException) {
            ConnectTest.assertEquals((String)"42Z60", (String)sQLException.getSQLState());
        }
        string2 = "drop table mytab";
        statement.execute(string2);
        statement.close();
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientTestDerby2026LoginTimeout() throws SQLException {
        String string = "jdbc:derby://" + TestConfiguration.getCurrent().getHostName() + ":" + TestConfiguration.getCurrent().getPort() + "/" + TestConfiguration.getCurrent().getDefaultDatabaseName();
        try {
            DriverManager.setLoginTimeout(10);
            try {
                Class.forName("org.apache.derby.jdbc.ClientDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                ConnectTest.fail((String)classNotFoundException.getMessage());
            }
            Connection connection = DriverManager.getConnection(string);
            TestRoutines.installRoutines(connection);
            CallableStatement callableStatement = connection.prepareCall("CALL TESTROUTINE.SLEEP(20000)");
            callableStatement.execute();
            connection.rollback();
        }
        finally {
            DriverManager.setLoginTimeout(0);
        }
    }
}

