/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.direct;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derbyTesting.system.oe.client.Submitter;
import org.apache.derbyTesting.system.oe.direct.StatementHelper;
import org.apache.derbyTesting.system.oe.model.Address;
import org.apache.derbyTesting.system.oe.model.Customer;
import org.apache.derbyTesting.system.oe.util.OERandom;

public class SimpleNonStandardOperations
extends StatementHelper {
    private final Customer customer = new Customer();
    private final Address address = new Address();
    private final OERandom rand;

    public SimpleNonStandardOperations(Connection connection, int n) throws SQLException {
        super(connection, false, n);
        this.rand = Submitter.getRuntimeRandom(connection);
    }

    public static SimpleNonStandardOperations noReset(Connection connection, int n) throws SQLException {
        return new SimpleNonStandardOperations(connection, n){

            @Override
            protected void reset(PreparedStatement preparedStatement) {
            }
        };
    }

    public void customerInquiry(int n) throws SQLException {
        this.customerInquiry((short)this.rand.randomInt(1, n), this.rand.district(), this.rand.NURand1023());
    }

    public void customerInquiry(short s, short s2, int n) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("SELECT C_BALANCE, C_FIRST, C_MIDDLE, C_LAST, C_STREET_1, C_STREET_2, C_CITY, C_STATE, C_ZIP, C_PHONE FROM CUSTOMER WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        preparedStatement.setShort(1, s);
        preparedStatement.setShort(2, s2);
        preparedStatement.setInt(3, n);
        ResultSet resultSet = preparedStatement.executeQuery();
        resultSet.next();
        this.customer.clear();
        this.customer.setBalance(resultSet.getString("C_BALANCE"));
        this.customer.setFirst(resultSet.getString("C_FIRST"));
        this.customer.setMiddle(resultSet.getString("C_MIDDLE"));
        this.customer.setLast(resultSet.getString("C_LAST"));
        this.customer.setAddress(this.getAddress(this.address, resultSet, "C_STREET_1"));
        this.customer.setPhone(resultSet.getString("C_PHONE"));
        this.reset(preparedStatement);
        this.conn.commit();
    }

    public void customerAddressChange(int n) throws SQLException {
        this.customerAddressChange((short)this.rand.randomInt(1, n), this.rand.district(), this.rand.NURand1023());
    }

    public void customerAddressChange(short s, short s2, int n) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE CUSTOMER SET C_STREET_1 = ?, C_STREET_2 = ?, C_CITY = ?, C_STATE = ?, C_ZIP = ? WHERE C_W_ID = ? AND C_D_ID = ? AND C_ID = ?");
        preparedStatement.setString(1, this.rand.randomAString10_20());
        preparedStatement.setString(2, this.rand.randomAString10_20());
        preparedStatement.setString(3, this.rand.randomAString10_20());
        preparedStatement.setString(4, this.rand.randomState());
        preparedStatement.setString(5, this.rand.randomZIP());
        preparedStatement.setShort(6, s);
        preparedStatement.setShort(7, s2);
        preparedStatement.setInt(8, n);
        preparedStatement.executeUpdate();
        this.reset(preparedStatement);
        this.conn.commit();
    }
}

