/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RestrictiveFilePermissionsTest
extends BaseJDBCTestCase {
    static final String dbName = "RFPT_db";
    static final String dbName2 = "RFPT_db2";
    static final String exportFileName = "ourExport.txt";
    static final String exportFileName2 = "ourExport2.txt";
    static final String exportLobFileName = "ourExport.lob";
    static final String backupDir = "RFPT_backup";
    static final String derbyDotLog = "RFPT_db.log";
    static String home = null;
    static boolean supportsLaxTesting = false;
    public static final int NEGATIVE = 0;
    public static final int POSITIVE = 1;
    public static final int UNKNOWN = 2;
    private static final Set<PosixFilePermission> UNWANTED_PERMISSIONS = Collections.unmodifiableSet(EnumSet.of(PosixFilePermission.GROUP_EXECUTE, new PosixFilePermission[]{PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE}));

    public RestrictiveFilePermissionsTest(String name) {
        super(name);
    }

    public static Test suite() throws Exception {
        File f = new File("system/testPermissions");
        RestrictiveFilePermissionsTest.assertTrue((boolean)f.mkdirs());
        supportsLaxTesting = RestrictiveFilePermissionsTest.checkAccessToOwner(f, false, 2);
        if (!supportsLaxTesting) {
            RestrictiveFilePermissionsTest.println("warning: testing of lax file permissions inRestrictiveFilePermissionsTest can not take place, use a more liberal runtime default (umask) for the tests");
        }
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(f);
        BaseTestSuite totalSuite = new BaseTestSuite("RestrictiveFilePermissionsTest");
        Properties p = new Properties();
        p.put("derby.storage.useDefaultFilePermissions", "false");
        p.put("derby.stream.error.file", derbyDotLog);
        totalSuite.addTest((Test)new SystemPropertyTestSetup((Test)TestConfiguration.singleUseDatabaseDecorator((Test)new SupportFilesSetup((Test)new BaseTestSuite(RestrictiveFilePermissionsTest.class, "haveWeGotAllCreatedFilesSuite"), new String[]{"functionTests/tests/lang/dcl_id.jar"}), dbName), p, true));
        if (Derby.hasServer()) {
            totalSuite.addTest((Test)new NetworkServerTestSetup((Test)new RestrictiveFilePermissionsTest("doTestCliServerIsRestrictive"), new String[0], new String[0], true));
        }
        if (supportsLaxTesting) {
            totalSuite.addTest(TestConfiguration.clientServerDecorator((Test)new RestrictiveFilePermissionsTest("doTestNonCliServerIsLax")));
            p = new Properties();
            p.put("derby.stream.error.file", "RFPT_db.log.lax");
            totalSuite.addTest((Test)new SystemPropertyTestSetup((Test)new RestrictiveFilePermissionsTest("dotestEmbeddedIsLax"), p, true));
        }
        return totalSuite;
    }

    public void setUp() throws Exception {
        this.getConnection();
        home = RestrictiveFilePermissionsTest.getSystemProperty("derby.system.home");
    }

    public void testDerbyDotLog() throws Exception {
        File derbydotlog = new File(home, derbyDotLog);
        RestrictiveFilePermissionsTest.checkAccessToOwner(derbydotlog, 1);
    }

    public void testDbDirectory() throws Exception {
        File derbyDbDir = new File(home, dbName);
        RestrictiveFilePermissionsTest.checkAccessToOwner(derbyDbDir, 1);
    }

    public void testServiceProperties() throws Exception {
        File servProp = new File(home, "RFPT_db/service.properties");
        RestrictiveFilePermissionsTest.checkAccessToOwner(servProp, 1);
    }

    public void testTmpDirectory() throws Exception {
        File tmp = new File(home, "RFPT_db/tmp");
        this.prepareStatement("declare global temporary table foo(i int) on commit preserve rows not logged").executeUpdate();
        RestrictiveFilePermissionsTest.checkAccessToOwner(tmp, true, 1);
    }

    public void testLockFiles() throws Exception {
        File dbLck = new File(home, "RFPT_db/db.lck");
        File dbexLck = new File(home, "RFPT_db/dbex.lck");
        RestrictiveFilePermissionsTest.checkAccessToOwner(dbLck, 1);
        if (PrivilegedFileOpsForTests.exists(dbexLck)) {
            RestrictiveFilePermissionsTest.checkAccessToOwner(dbexLck, 1);
        }
    }

    public void testSeg0AndConglomerates() throws Exception {
        File seg0 = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(seg0, true, 1);
    }

    public void testLogDirAndLogFiles() throws Exception {
        File seg0 = new File(home, "RFPT_db/log");
        RestrictiveFilePermissionsTest.checkAccessToOwner(seg0, true, 1);
    }

    public void testExportedFiles() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE(    'SYS',    'SYSTABLES',    '" + home + "/RFPT_db/ourExport.txt',    NULL,    NULL,    NULL)");
        File exp = new File(home, "RFPT_db/ourExport.txt");
        RestrictiveFilePermissionsTest.checkAccessToOwner(exp, 1);
        s.executeUpdate("create table lobtable(i int, c clob)");
        PreparedStatement ps = this.prepareStatement("insert into lobtable values (1,?)");
        ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader(1000L), 1000);
        ps.executeUpdate();
        s.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE_LOBS_TO_EXTFILE(    'SYS',    'SYSTABLES',    '" + home + "/RFPT_db/ourExport2.txt',    NULL,    NULL,    NULL,    '" + home + "/RFPT_db/ourExport.lob')");
        File exp2 = new File(home, "RFPT_db/ourExport2.txt");
        File expLob = new File(home, "RFPT_db/ourExport.lob");
        RestrictiveFilePermissionsTest.checkAccessToOwner(exp2, 1);
        RestrictiveFilePermissionsTest.checkAccessToOwner(expLob, 1);
    }

    public void testConglomsAfterCompress() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("create table comptable(i int primary key, j int)");
        s.executeUpdate("create index secondary on comptable(j)");
        PreparedStatement ps = this.prepareStatement("insert into comptable values (?,?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 10000; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        this.commit();
        s.executeUpdate("delete from comptable where MOD(i, 2) = 0");
        this.commit();
        this.setAutoCommit(true);
        s.executeUpdate("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE('APP', 'COMPTABLE', 0)");
        File seg0 = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(seg0, true, 1);
    }

    public void testTruncateTable() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("create table trunctable(i int)");
        PreparedStatement ps = this.prepareStatement("insert into trunctable values (?)");
        this.setAutoCommit(false);
        for (int i = 0; i < 1000; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
        s.executeUpdate("truncate table trunctable");
        File seg0 = new File(home, "RFPT_db/seg0");
        RestrictiveFilePermissionsTest.checkAccessToOwner(seg0, true, 1);
    }

    public void testBackupRestoreFiles() throws Exception {
        URL jar = SupportFilesSetup.getReadOnlyURL("dcl_id.jar");
        RestrictiveFilePermissionsTest.assertNotNull((String)"dcl_id.jar", (Object)jar);
        CallableStatement cs = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        cs.setString(1, jar.toExternalForm());
        cs.setString(2, "testBackupFiles");
        cs.executeUpdate();
        this.prepareStatement("declare global temporary table foo(i int) on commit preserve rows not logged").executeUpdate();
        cs = this.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        String fullBackupDir = home + "/RFPT_backup";
        cs.setString(1, fullBackupDir);
        cs.execute();
        File fbd = new File(fullBackupDir);
        RestrictiveFilePermissionsTest.checkAccessToOwner(fbd, true, 1);
        File db = new File(home, dbName);
        RestrictiveFilePermissionsTest.checkAccessToOwner(db, true, 1);
        TestConfiguration.getCurrent().shutdownDatabase();
        DataSource ds = JDBCDataSource.getDataSource();
        String fullRestoreDir = home + "/RFPT_backup/RFPT_db";
        JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "restoreFrom=" + fullRestoreDir);
        Connection con = ds.getConnection();
        RestrictiveFilePermissionsTest.checkAccessToOwner(db, true, 1);
        con.close();
        DataSource ds2 = JDBCDataSource.getDataSource(dbName2);
        JDBCDataSource.setBeanProperty(ds2, "connectionAttributes", "restoreFrom=" + fullRestoreDir);
        Connection con2 = ds2.getConnection();
        File newDb = new File(home, dbName2);
        RestrictiveFilePermissionsTest.checkAccessToOwner(newDb, true, 1);
        con2.close();
        DataSource[] srcs = new DataSource[]{JDBCDataSource.getDataSource(), JDBCDataSource.getDataSource(dbName2)};
        for (int i = 0; i < srcs.length; ++i) {
            JDBCDataSource.setBeanProperty(srcs[i], "connectionAttributes", "shutdown=true");
            try {
                srcs[i].getConnection();
                RestrictiveFilePermissionsTest.fail((String)"shutdown failed: expected exception");
                continue;
            }
            catch (SQLException e) {
                RestrictiveFilePermissionsTest.assertSQLState("database shutdown", "08006", e);
            }
        }
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(newDb);
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(new File(home + "/RFPT_backup"));
    }

    public void testJarFiles() throws Exception {
        URL jar = SupportFilesSetup.getReadOnlyURL("dcl_id.jar");
        RestrictiveFilePermissionsTest.assertNotNull((String)"dcl_id.jar", (Object)jar);
        CallableStatement cs = this.prepareCall("CALL SQLJ.INSTALL_JAR(?, ?, 0)");
        cs.setString(1, jar.toExternalForm());
        cs.setString(2, "anyName");
        cs.executeUpdate();
        File jarsDir = new File(home, "RFPT_db/jar");
        RestrictiveFilePermissionsTest.checkAccessToOwner(jarsDir, true, 1);
    }

    public void doTestCliServerIsRestrictive() throws Exception {
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        String traceDir = home + "/RFPT_db_tracefiles_restr";
        nsctrl.setTraceDirectory(traceDir);
        nsctrl.trace(true);
        nsctrl.ping();
        nsctrl.trace(false);
        File traceDirF = new File(traceDir);
        RestrictiveFilePermissionsTest.checkAccessToOwner(traceDirF, true, 1);
        nsctrl.shutdown();
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(traceDirF);
    }

    public void doTestNonCliServerIsLax() throws Exception {
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        String traceDir = home + "/RFPT_db_tracefiles_lax";
        nsctrl.setTraceDirectory(traceDir);
        nsctrl.trace(true);
        nsctrl.ping();
        nsctrl.trace(false);
        File traceDirF = new File(traceDir);
        RestrictiveFilePermissionsTest.checkAccessToOwner(traceDirF, true, 0);
        nsctrl.shutdown();
        RestrictiveFilePermissionsTest.assertDirectoryDeleted(traceDirF);
    }

    public void dotestEmbeddedIsLax() throws Exception {
        File derbydotlogF = new File(home, "RFPT_db.log.lax");
        RestrictiveFilePermissionsTest.checkAccessToOwner(derbydotlogF, 0);
    }

    public static void checkAccessToOwner(File file, int expectedOutcome) throws Exception {
        RestrictiveFilePermissionsTest.checkAccessToOwner(file, false, expectedOutcome);
    }

    private static boolean checkAccessToOwner(File file, boolean doContents, int expectedOutcome) throws Exception {
        if (doContents) {
            RestrictiveFilePermissionsTest.checkAccessToOwner(file, false, expectedOutcome);
            for (File f : PrivilegedFileOpsForTests.listFiles(file)) {
                RestrictiveFilePermissionsTest.checkAccessToOwner(f, false, expectedOutcome);
            }
        }
        boolean someThingBeyondOwnerFound = false;
        Path fileP = Paths.get(file.getPath(), new String[0]);
        AclFileAttributeView aclView = Files.getFileAttributeView(fileP, AclFileAttributeView.class, new LinkOption[0]);
        PosixFileAttributeView posixView = Files.getFileAttributeView(fileP, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixView != null) {
            for (PosixFilePermission perm : posixView.readAttributes().permissions()) {
                if (!UNWANTED_PERMISSIONS.contains((Object)perm)) continue;
                if (expectedOutcome == 1) {
                    RestrictiveFilePermissionsTest.fail((String)("unwanted permission " + String.valueOf((Object)perm) + " for file " + String.valueOf(file)));
                }
                someThingBeyondOwnerFound = true;
                break;
            }
        } else if (aclView != null) {
            UserPrincipal owner = Files.getOwner(fileP, new LinkOption[0]);
            for (AclEntry ace : aclView.getAcl()) {
                UserPrincipal princ = ace.principal();
                if (princ.equals(owner)) continue;
                if (expectedOutcome == 1) {
                    RestrictiveFilePermissionsTest.fail((String)("unexpected uid " + princ.getName() + " can access file " + String.valueOf(file)));
                }
                someThingBeyondOwnerFound = true;
                break;
            }
        } else {
            RestrictiveFilePermissionsTest.fail();
        }
        if (expectedOutcome == 0 && !someThingBeyondOwnerFound) {
            RestrictiveFilePermissionsTest.fail((String)("unexpected restrictive access: " + String.valueOf(file)));
        }
        if (expectedOutcome != 2) {
            RestrictiveFilePermissionsTest.println("checked perms on: " + String.valueOf(file));
        }
        return expectedOutcome == 2 && someThingBeyondOwnerFound;
    }
}

