/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.whereclausebuilder;

import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.AbstractWhereClausePsPartBuilder;

public class NullValueBuilder
extends AbstractWhereClausePsPartBuilder {
    public PreparedStatementPart buildPs(WhereClauseExpression whereClausePart, boolean ignoreCase, Adapter adapter) throws TorqueException {
        if (whereClausePart.getOperator().equals(SqlEnum.ISNULL) || whereClausePart.getOperator().equals(SqlEnum.ISNOTNULL)) {
            PreparedStatementPart result = NullValueBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCase, adapter);
            result.getSql().append(whereClausePart.getOperator());
            return result;
        }
        if (whereClausePart.getOperator().equals(SqlEnum.EQUAL)) {
            PreparedStatementPart result = NullValueBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCase, adapter);
            result.getSql().append(SqlEnum.ISNULL);
            return result;
        }
        if (whereClausePart.getOperator().equals(SqlEnum.NOT_EQUAL) || whereClausePart.getOperator().equals(SqlEnum.ALT_NOT_EQUAL)) {
            PreparedStatementPart result = NullValueBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCase, adapter);
            result.getSql().append(SqlEnum.ISNOTNULL);
            return result;
        }
        throw new IllegalStateException("unknown operator " + whereClausePart.getOperator());
    }

    public boolean isApplicable(WhereClauseExpression whereClauseExpression, Adapter adapter) {
        if (whereClauseExpression.getOperator().equals(SqlEnum.ISNULL) || whereClauseExpression.getOperator().equals(SqlEnum.ISNOTNULL)) {
            return true;
        }
        Object rValue = whereClauseExpression.getRValue();
        if (!(rValue == null || rValue instanceof ObjectKey && ((ObjectKey)rValue).getValue() == null)) {
            return false;
        }
        return whereClauseExpression.getOperator().equals(SqlEnum.EQUAL) || whereClauseExpression.getOperator().equals(SqlEnum.NOT_EQUAL) || whereClauseExpression.getOperator().equals(SqlEnum.ALT_NOT_EQUAL);
    }
}

