/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.mergepoint;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.mergepoint.ActionSaxHandlerFactory;
import org.apache.torque.generator.configuration.mergepoint.ApplyActionSaxHandlerFactory;
import org.apache.torque.generator.configuration.mergepoint.OptionActionSaxHandlerFactory;
import org.apache.torque.generator.configuration.mergepoint.OutputActionSaxHandlerFactory;
import org.apache.torque.generator.configuration.mergepoint.SourceElementAttributeActionSaxHandlerFactory;
import org.apache.torque.generator.configuration.mergepoint.TraverseAllActionSaxHandlerFactory;

public class ActionSaxHandlerFactories {
    private static Log log = LogFactory.getLog(ActionSaxHandlerFactories.class);
    private final Map<String, ActionSaxHandlerFactory> actionSaxHandlerFactories = new HashMap<String, ActionSaxHandlerFactory>();

    public ActionSaxHandlerFactories() {
        try {
            this.register(new TraverseAllActionSaxHandlerFactory());
            this.register(new ApplyActionSaxHandlerFactory());
            this.register(new OptionActionSaxHandlerFactory());
            this.register(new SourceElementAttributeActionSaxHandlerFactory());
            this.register(new OutputActionSaxHandlerFactory());
        }
        catch (ConfigurationException e) {
            log.error((Object)"caught ConfigurationException while registering the default Action Sax Handler Factories", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void register(ActionSaxHandlerFactory factory) throws ConfigurationException {
        ActionSaxHandlerFactory oldFactory = this.actionSaxHandlerFactories.get(factory.getType());
        if (oldFactory != null) {
            throw new ConfigurationException("Attempted to register an ActionSaxHandlerFactory of type " + factory.getType() + " and class " + factory.getClass().getName() + " : A factory with this type already exists,  it has the class " + oldFactory.getClass().getName());
        }
        this.actionSaxHandlerFactories.put(factory.getType(), factory);
    }

    public ActionSaxHandlerFactory getActionSaxHandlerFactory(String type) {
        return this.actionSaxHandlerFactories.get(type);
    }
}

