/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory;

import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.commons.jcs3.auxiliary.disk.jdbc.dsfactory.DataSourceFactory;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;

public class JndiDataSourceFactory
implements DataSourceFactory {
    private static final Log log = LogManager.getLog(JndiDataSourceFactory.class);
    private String name;
    private String path;
    private Context ctx;
    private DataSource ds;
    private long lastLookup;
    private long ttl;

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSource getDataSource() throws SQLException {
        long time = System.currentTimeMillis();
        if (this.ds == null || time - this.lastLookup > this.ttl) {
            try {
                Context context = this.ctx;
                synchronized (context) {
                    this.ds = (DataSource)this.ctx.lookup(this.path);
                }
                this.lastLookup = time;
            }
            catch (NamingException e) {
                throw new SQLException(e);
            }
        }
        return this.ds;
    }

    @Override
    public void initialize(JDBCDiskCacheAttributes config) throws SQLException {
        this.name = config.getConnectionPoolName();
        this.initJNDI(config);
    }

    private void initJNDI(JDBCDiskCacheAttributes config) throws SQLException {
        log.debug("Starting initJNDI");
        try {
            this.path = config.getJndiPath();
            log.debug("JNDI path: {0}", this.path);
            this.ttl = config.getJndiTTL();
            log.debug("Time between context lookups: {0}", this.ttl);
            Hashtable env = new Hashtable();
            this.ctx = new InitialContext(env);
            if (log.isTraceEnabled()) {
                log.trace("Created new InitialContext");
                JndiDataSourceFactory.debugCtx(this.ctx);
            }
        }
        catch (NamingException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void close() {
    }

    private static void debugCtx(Context ctx) throws NamingException {
        log.trace("InitialContext -------------------------------");
        Hashtable<?, ?> env = ctx.getEnvironment();
        log.trace("Environment properties: {0}", env.size());
        env.forEach((key, value) -> log.trace("    {0}: {1}", key, value));
        log.trace("----------------------------------------------");
    }
}

