/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { Version } from '../util'

describe('test dubbo version check suite', () => {
  it('test getIntVersion', () => {
    const v1 = Version.getIntVersion('2.0.2')
    expect(v1).toEqual(2000200)

    const v2 = Version.getIntVersion('2.0.99')
    expect(v2).toEqual(2009900)
  })

  it('test getPrefixDigits', () => {
    const v = Version.getPrefixDigits('2.0.22')
    expect(v).toEqual('2')
    const v1 = Version.getPrefixDigits('stable')
    expect(v1).toEqual('')
  })

  it('test isSupportResponseAttachment', () => {
    const isSupport1 = Version.isSupportResponseAttachment('2.0.3')
    expect(isSupport1).toEqual(true)

    const isSupport2 = Version.isSupportResponseAttachment('2.0.98')
    expect(isSupport2).toEqual(true)

    const isSupport3 = Version.isSupportResponseAttachment('2.0.100')
    expect(isSupport3).toEqual(false)

    const isSupport4 = Version.isSupportResponseAttachment('2.0.1')
    expect(isSupport4).toEqual(false)
  })
})
