/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.atomos.utils.substrate.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.felix.atomos.utils.substrate.impl.DefaultNativeImageArguments;

public class NativeImageArgumentsImpl
implements DefaultNativeImageArguments {
    boolean allowIncompleteClasspath = false;
    final List<Path> classPathFiles = new ArrayList<Path>();
    boolean debugAttach = false;
    final List<Path> dynamicProxyConfigurationFiles = new ArrayList<Path>();
    String imageName;
    final List<String> initializeAtBuildTime = new ArrayList<String>();
    String mainClass;
    boolean noFallback = true;
    final List<Path> reflectionConfigurationFiles = new ArrayList<Path>();
    boolean reportExceptionStackTraces = false;
    boolean reportUnsupportedElementsAtRuntime = false;
    final List<Path> resourceConfigurationFiles = new ArrayList<Path>();
    boolean traceClassInitialization = false;
    boolean verbose = true;
    final List<String> vmFlags = new ArrayList<String>();
    final Map<String, String> vmSystemProperties = new HashMap<String, String>();
    boolean printClassInitialization = false;

    private static List<String> addArgIfExitsPath(List<String> arguments, String parameterName, List<Path> values) {
        if (values != null && !values.isEmpty()) {
            arguments.add(NativeImageArgumentsImpl.combineArgPath(parameterName, values.stream()));
        }
        return arguments;
    }

    private static String combineArg(String parameterName, Stream<String> values) {
        return NativeImageArgumentsImpl.combineArg(parameterName, values.filter(Objects::nonNull).sorted().collect(Collectors.joining(",")));
    }

    private static String combineArg(String parameterName, String value) {
        return parameterName + "=" + value;
    }

    private static String combineArgPath(String parameterName, Stream<Path> values) {
        return NativeImageArgumentsImpl.combineArg(parameterName, values.filter(Objects::nonNull).sorted(NativeImageArgumentsImpl::byAbsolutePath).map(Path::toAbsolutePath).map(Path::toString));
    }

    private static int byAbsolutePath(Path p1, Path p2) {
        return p1.toAbsolutePath().toString().compareTo(p2.toAbsolutePath().toString());
    }

    NativeImageArgumentsImpl() {
    }

    private List<String> addArgIfExits(List<String> arguments, String parameterName, List<String> values) {
        if (values != null && !values.isEmpty()) {
            arguments.add(NativeImageArgumentsImpl.combineArg(parameterName, values.stream()));
        }
        return arguments;
    }

    private List<String> addArgIfTrue(List<String> arguments, String parameterName, boolean value) {
        if (value) {
            arguments.add(parameterName);
        }
        return arguments;
    }

    @Override
    public boolean allowIncompleteClasspath() {
        return this.allowIncompleteClasspath;
    }

    public List<String> arguments() {
        ArrayList<String> arguments = new ArrayList<String>();
        ArrayList<String> otherArguments = new ArrayList<String>();
        arguments.add("-cp");
        String cp = this.classPathFiles().stream().filter(Objects::nonNull).map(Path::toAbsolutePath).sorted(NativeImageArgumentsImpl::byAbsolutePath).map(Path::toString).collect(Collectors.joining(":"));
        arguments.add(cp);
        this.addArgIfTrue(otherArguments, "--verbose", this.verbose);
        this.addArgIfExits(otherArguments, "--initialize-at-build-time", this.initializeAtBuildTime());
        NativeImageArgumentsImpl.addArgIfExitsPath(otherArguments, "-H:ReflectionConfigurationFiles", this.reflectionConfigurationFiles());
        NativeImageArgumentsImpl.addArgIfExitsPath(otherArguments, "-H:ResourceConfigurationFiles", this.resourceConfigurationFiles());
        NativeImageArgumentsImpl.addArgIfExitsPath(otherArguments, "-H:DynamicProxyConfigurationFiles", this.dynamicProxyConfigurationFiles());
        this.addArgIfTrue(otherArguments, "--allow-incomplete-classpath", this.allowIncompleteClasspath());
        this.addArgIfTrue(otherArguments, "-H:+ReportUnsupportedElementsAtRuntime", this.reportUnsupportedElementsAtRuntime());
        this.addArgIfTrue(otherArguments, "-H:+ReportExceptionStackTraces", this.reportExceptionStackTraces());
        this.addArgIfTrue(otherArguments, "-H:+PrintClassInitialization", this.traceClassInitialization());
        this.addArgIfTrue(otherArguments, "--no-fallback", this.noFallback());
        this.addArgIfTrue(otherArguments, "--debug-attach", this.debugAttach());
        this.addArgIfTrue(otherArguments, "-H:+PrintClassInitialization", this.printClassInitialization());
        otherArguments.add(NativeImageArgumentsImpl.combineArg("-H:Class", this.mainClass()));
        otherArguments.add(NativeImageArgumentsImpl.combineArg("-H:Name", this.name()));
        this.vmSystemProperties().forEach((k, v) -> otherArguments.add(NativeImageArgumentsImpl.combineArg("-D" + k, v)));
        this.vmFlags().forEach(flag -> otherArguments.add("-J" + flag));
        List<String> additionalArguments = this.additionalArguments();
        if (additionalArguments != null && !additionalArguments.isEmpty()) {
            otherArguments.addAll(this.additionalArguments());
        }
        otherArguments.sort((o1, o2) -> o1.compareTo((String)o2));
        arguments.addAll(otherArguments);
        return arguments;
    }

    public boolean printClassInitialization() {
        return this.printClassInitialization;
    }

    @Override
    public List<Path> classPathFiles() {
        return this.classPathFiles;
    }

    @Override
    public boolean debugAttach() {
        return this.debugAttach;
    }

    @Override
    public List<Path> dynamicProxyConfigurationFiles() {
        return this.dynamicProxyConfigurationFiles;
    }

    @Override
    public List<String> initializeAtBuildTime() {
        return this.initializeAtBuildTime;
    }

    @Override
    public String mainClass() {
        return this.mainClass;
    }

    @Override
    public String name() {
        return this.imageName;
    }

    @Override
    public boolean noFallback() {
        return this.noFallback;
    }

    @Override
    public List<Path> reflectionConfigurationFiles() {
        return this.reflectionConfigurationFiles;
    }

    @Override
    public boolean reportExceptionStackTraces() {
        return this.reportExceptionStackTraces;
    }

    @Override
    public boolean reportUnsupportedElementsAtRuntime() {
        return this.reportUnsupportedElementsAtRuntime;
    }

    @Override
    public List<Path> resourceConfigurationFiles() {
        return this.resourceConfigurationFiles;
    }

    @Override
    public boolean traceClassInitialization() {
        return this.traceClassInitialization;
    }

    @Override
    public List<String> vmFlags() {
        return this.vmFlags;
    }

    @Override
    public Map<String, String> vmSystemProperties() {
        return this.vmSystemProperties;
    }

    @Override
    public boolean verbose() {
        return this.verbose;
    }
}

