/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.felix.configurator.impl.logger.SystemLogger;

public class WorkerQueue
implements Runnable {
    private final ThreadFactory threadFactory;
    private final List<Runnable> tasks = new ArrayList<Runnable>();
    private volatile Thread backgroundThread;
    private volatile boolean stopped = false;

    public WorkerQueue() {
        this.threadFactory = Executors.defaultThreadFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        List<Runnable> list = this.tasks;
        synchronized (list) {
            this.stopped = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Runnable r) {
        List<Runnable> list = this.tasks;
        synchronized (list) {
            if (!this.stopped) {
                this.tasks.add(r);
                if (this.backgroundThread == null) {
                    this.backgroundThread = this.threadFactory.newThread(this);
                    this.backgroundThread.setDaemon(true);
                    this.backgroundThread.setName("Apache Felix Configurator Worker Thread");
                    this.backgroundThread.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Runnable r;
        do {
            r = null;
            List<Runnable> list = this.tasks;
            synchronized (list) {
                if (!this.stopped && !this.tasks.isEmpty()) {
                    r = this.tasks.remove(0);
                } else {
                    this.backgroundThread = null;
                }
            }
            if (r == null) continue;
            try {
                r.run();
            }
            catch (Throwable t) {
                SystemLogger.error("Error processing task" + t.getMessage(), t);
            }
        } while (r != null);
    }
}

