/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deployment.rp.autoconf;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.felix.metatype.Attribute;
import org.apache.felix.metatype.Designate;
import org.osgi.service.deploymentadmin.spi.ResourceProcessorException;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetaTypeUtil {
    private MetaTypeUtil() {
    }

    public static Dictionary getProperties(Designate designate, ObjectClassDefinition ocd) throws ResourceProcessorException {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        AttributeDefinition[] attributeDefs = ocd.getAttributeDefinitions(-1);
        List attributes = designate.getObject().getAttributes();
        for (Attribute attribute : attributes) {
            String adRef = attribute.getAdRef();
            boolean found = false;
            for (int j = 0; j < attributeDefs.length; ++j) {
                AttributeDefinition ad = attributeDefs[j];
                if (!adRef.equals(ad.getID())) continue;
                Object value = MetaTypeUtil.getValue(attribute, ad);
                if (value == null) {
                    if (designate.isOptional()) {
                        properties = null;
                        break;
                    }
                    throw new ResourceProcessorException(463, "Could not match attribute to it's definition: adref=" + adRef);
                }
                ((Dictionary)properties).put(adRef, value);
                found = true;
                break;
            }
            if (found) continue;
            if (designate.isOptional()) {
                properties = null;
                break;
            }
            throw new ResourceProcessorException(463, "Could not find attribute definition: adref=" + adRef);
        }
        return properties;
    }

    private static Object getValue(Attribute attribute, AttributeDefinition ad) throws ResourceProcessorException {
        if (attribute == null || ad == null || !attribute.getAdRef().equals(ad.getID())) {
            return null;
        }
        String[] content = attribute.getContent();
        int type = ad.getType();
        Boolean[] typedContent = null;
        try {
            block13: for (int i = 0; i < content.length; ++i) {
                String value = content[i];
                switch (type) {
                    case 11: {
                        typedContent = typedContent == null ? new Boolean[content.length] : typedContent;
                        typedContent[i] = Boolean.valueOf(value);
                        continue block13;
                    }
                    case 6: {
                        typedContent = typedContent == null ? new Byte[content.length] : typedContent;
                        typedContent[i] = Byte.valueOf(value);
                        continue block13;
                    }
                    case 5: {
                        typedContent = typedContent == null ? new Character[content.length] : typedContent;
                        char[] charArray = value.toCharArray();
                        if (charArray.length == 1) {
                            typedContent[i] = new Character(charArray[0]);
                            continue block13;
                        }
                        throw new ResourceProcessorException(463, "Unable to parse value for definition: adref=" + ad.getID());
                    }
                    case 7: {
                        typedContent = typedContent == null ? new Double[content.length] : typedContent;
                        typedContent[i] = Double.valueOf(value);
                        continue block13;
                    }
                    case 8: {
                        typedContent = typedContent == null ? new Float[content.length] : typedContent;
                        typedContent[i] = Float.valueOf(value);
                        continue block13;
                    }
                    case 3: {
                        typedContent = typedContent == null ? new Integer[content.length] : typedContent;
                        typedContent[i] = Integer.valueOf(value);
                        continue block13;
                    }
                    case 2: {
                        typedContent = typedContent == null ? new Long[content.length] : typedContent;
                        typedContent[i] = Long.valueOf(value);
                        continue block13;
                    }
                    case 4: {
                        typedContent = typedContent == null ? new Short[content.length] : typedContent;
                        typedContent[i] = Short.valueOf(value);
                        continue block13;
                    }
                    case 1: {
                        typedContent = typedContent == null ? new String[content.length] : typedContent;
                        typedContent[i] = value;
                        continue block13;
                    }
                    default: {
                        throw new ResourceProcessorException(463, "Unsupported value-type for definition: adref=" + ad.getID());
                    }
                }
            }
        }
        catch (NumberFormatException nfe) {
            throw new ResourceProcessorException(463, "Unable to parse value for definition: adref=" + ad.getID());
        }
        int cardinality = ad.getCardinality();
        Object result = null;
        if (cardinality == 0) {
            result = typedContent.length == 1 ? typedContent[0] : null;
        } else if (cardinality == Integer.MIN_VALUE) {
            result = new Vector<Boolean>(Arrays.asList(typedContent));
        } else if (cardinality == Integer.MAX_VALUE) {
            result = typedContent;
        } else if (cardinality < 0) {
            result = typedContent.length <= Math.abs(cardinality) ? new Vector<Boolean>(Arrays.asList(typedContent)) : null;
        } else if (cardinality > 0) {
            result = typedContent.length <= cardinality ? typedContent : null;
        }
        return result;
    }
}

