/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl;

import java.util.List;
import org.apache.felix.hc.api.FormattingResultLog;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;

public class CompositeResult
extends Result {
    public CompositeResult(ResultLog log, List<HealthCheckExecutionResult> executionResults) {
        super(log);
        for (HealthCheckExecutionResult executionResult : executionResults) {
            HealthCheckMetadata healthCheckMetadata = executionResult.getHealthCheckMetadata();
            Result healthCheckResult = executionResult.getHealthCheckResult();
            for (ResultLog.Entry entry : healthCheckResult) {
                this.resultLog.add(new ResultLog.Entry(entry.getStatus(), healthCheckMetadata.getName() + ": " + entry.getMessage(), entry.getException()));
            }
            this.resultLog.add(new ResultLog.Entry(healthCheckMetadata.getName() + " finished after " + FormattingResultLog.msHumanReadable((long)executionResult.getElapsedTimeInMs()) + (executionResult.hasTimedOut() ? " (timed out)" : ""), true));
        }
    }
}

