/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.executor;

import java.text.Collator;
import java.util.Date;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.execution.HealthCheckExecutionResult;
import org.apache.felix.hc.api.execution.HealthCheckMetadata;

public class ExecutionResult
implements Comparable<ExecutionResult>,
HealthCheckExecutionResult {
    private final Result resultFromHC;
    private final HealthCheckMetadata metaData;
    private final Date finishedAt;
    private final long elapsedTimeInMs;
    private final boolean timedOut;

    public ExecutionResult(HealthCheckMetadata metadata, Result simpleResult, long elapsedTimeInMs, boolean timedout) {
        this(metadata, simpleResult, new Date(), elapsedTimeInMs, timedout);
    }

    public ExecutionResult(HealthCheckMetadata metadata, Result simpleResult, Date finishedAt, long elapsedTimeInMs, boolean timedout) {
        this.metaData = metadata;
        this.resultFromHC = simpleResult;
        this.finishedAt = finishedAt;
        this.elapsedTimeInMs = elapsedTimeInMs;
        this.timedOut = timedout;
    }

    public ExecutionResult(HealthCheckMetadata metadata, Result simpleResult, long elapsedTimeInMs) {
        this(metadata, simpleResult, elapsedTimeInMs, false);
    }

    public ExecutionResult(HealthCheckMetadata metadata, Result.Status status, String errorMessage, long elapsedTime, boolean timedOut) {
        this(metadata, new Result(status, errorMessage), elapsedTime, timedOut);
    }

    public Result getHealthCheckResult() {
        return this.resultFromHC;
    }

    public String toString() {
        return "ExecutionResult [status=" + this.resultFromHC.getStatus() + ", finishedAt=" + this.finishedAt + ", elapsedTimeInMs=" + this.elapsedTimeInMs + ", timedOut=" + this.timedOut + "]";
    }

    public long getElapsedTimeInMs() {
        return this.elapsedTimeInMs;
    }

    public HealthCheckMetadata getHealthCheckMetadata() {
        return this.metaData;
    }

    public Date getFinishedAt() {
        return this.finishedAt;
    }

    public boolean hasTimedOut() {
        return this.timedOut;
    }

    @Override
    public int compareTo(ExecutionResult otherResult) {
        int retVal = otherResult.getHealthCheckResult().getStatus().compareTo((Enum)this.getHealthCheckResult().getStatus());
        if (retVal == 0) {
            retVal = Collator.getInstance().compare(this.getHealthCheckMetadata().getTitle(), otherResult.getHealthCheckMetadata().getTitle());
        }
        return retVal;
    }

    long getServiceId() {
        return this.metaData.getServiceId();
    }
}

