/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.osgi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.felix.httplite.osgi.HttpServiceImpl;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.server.Server;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class HttpServiceFactoryImpl
implements ServiceFactory {
    private final Logger m_logger;
    private final Server m_server;
    private List m_registrations;
    private final HashMap m_servletMap;

    public HttpServiceFactoryImpl(Logger logger, Server m_server) {
        this.m_logger = logger;
        this.m_server = m_server;
        this.m_servletMap = new HashMap();
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        HttpServiceImpl httpService = null;
        try {
            httpService = new HttpServiceImpl(bundle, this.m_server, this.m_logger, this.m_servletMap);
            if (this.m_server.getState() != 1) {
                this.m_logger.log(3, "Starting http server.");
                httpService.start();
            }
            if (this.m_registrations == null) {
                this.m_registrations = new ArrayList();
            }
            this.m_registrations.add(this.serializeRegistration(bundle, registration));
        }
        catch (IOException e) {
            this.m_logger.log(1, "Unable to create Http Service.", e);
            return null;
        }
        return httpService;
    }

    private String serializeRegistration(Bundle bundle, ServiceRegistration registration) {
        return registration.toString() + bundle.getBundleId();
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        if (this.m_registrations == null) {
            throw new IllegalStateException("m_registrations has not been initialized.");
        }
        String key = this.serializeRegistration(bundle, registration);
        if (!this.m_registrations.contains(key)) {
            throw new IllegalStateException("Untracked service registration.");
        }
        this.m_registrations.remove(key);
        if (this.m_registrations.size() == 0 && this.m_server.getState() == 1) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(30000L);
                        if (HttpServiceFactoryImpl.this.m_registrations == null || HttpServiceFactoryImpl.this.m_server == null || Thread.interrupted()) {
                            return;
                        }
                        if (HttpServiceFactoryImpl.this.m_registrations.size() == 0 && HttpServiceFactoryImpl.this.m_server.getState() == 1) {
                            HttpServiceFactoryImpl.this.m_logger.log(3, "Stopping http server since no clients are registered.");
                            HttpServiceFactoryImpl.this.m_server.setStopping();
                            HttpServiceFactoryImpl.this.m_server.stop();
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }).start();
        }
    }
}

