/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.httplite.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.felix.httplite.osgi.Logger;
import org.apache.felix.httplite.osgi.ServiceRegistration;
import org.apache.felix.httplite.osgi.ServiceRegistrationHandler;
import org.apache.felix.httplite.servlet.HttpServletRequestImpl;
import org.apache.felix.httplite.servlet.HttpServletResponseImpl;
import org.osgi.service.http.HttpContext;

public class ResourceHandler
implements ServiceRegistrationHandler {
    private static final String INDEX_HTML = "index.html";
    private final HttpServletRequestImpl m_request;
    private final HttpServletResponseImpl m_response;
    private final HttpContext m_httpContext;
    private final String m_name;
    private final String m_alias;
    private final Logger m_logger;
    private final int m_aliasIndex;

    public ResourceHandler(HttpServletRequestImpl req, HttpServletResponseImpl res, ServiceRegistration resource, Logger logger) {
        if (resource.isServlet()) {
            throw new IllegalStateException("Invalid state, ResourceHandler constructed with a Servlet.");
        }
        this.m_request = req;
        this.m_response = res;
        this.m_httpContext = resource.getContext();
        this.m_name = resource.getName();
        this.m_alias = resource.getAlias();
        this.m_aliasIndex = this.m_alias.length();
        this.m_logger = logger;
    }

    public void handle(boolean close) throws IOException {
        if (!this.m_request.getMethod().equals("GET") && !this.m_request.getMethod().equals("HEAD")) {
            this.m_logger.log(2, "Ignored client " + this.m_request.getMethod() + " on static resource.");
            return;
        }
        if (this.m_httpContext.handleSecurity(this.m_request, this.m_response)) {
            String resourceName = this.getResourceName(this.m_request.getRequestURI());
            URL resource = null;
            if (resourceName.endsWith("/")) {
                this.m_logger.log(4, "Appending index.html to request " + resourceName);
                resource = this.m_httpContext.getResource(resourceName + INDEX_HTML);
            } else {
                resource = this.m_httpContext.getResource(resourceName);
            }
            if (resource == null) {
                this.m_logger.log(3, "Returning HTTP 404 for request for " + resourceName);
                this.m_response.sendError(404);
                return;
            }
            InputStream inputStream = resource.openStream();
            this.m_response.setContentType(this.m_httpContext.getMimeType(resourceName));
            this.m_response.writeToOutputStream(inputStream, close);
        }
    }

    private String getResourceName(String path) {
        if (path.startsWith("/")) {
            return this.m_name + path.substring(this.m_aliasIndex);
        }
        return this.m_name + "/" + path.substring(this.m_aliasIndex);
    }
}

