/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.linker;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.FactoryStateListener;
import org.apache.felix.ipojo.IPojoFactory;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.extender.ExtensionDeclaration;
import org.apache.felix.ipojo.extender.InstanceDeclaration;
import org.apache.felix.ipojo.extender.TypeDeclaration;
import org.apache.felix.ipojo.extender.builder.FactoryBuilderException;
import org.apache.felix.ipojo.extender.internal.DefaultJob;
import org.apache.felix.ipojo.extender.internal.Lifecycle;
import org.apache.felix.ipojo.extender.internal.linker.InstanceBundleContextAware;
import org.apache.felix.ipojo.extender.queue.QueueService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ManagedType
implements FactoryStateListener,
Lifecycle {
    public static final String FACTORY_CREATION_JOB_TYPE = "factory.creation";
    public static final String INSTANCE_STARTUP_JOB_TYPE = "instance.startup";
    private final BundleContext m_bundleContext;
    private final QueueService m_queueService;
    private final TypeDeclaration m_declaration;
    private ServiceTracker m_extensionTracker;
    private ServiceTracker m_instanceTracker;
    private Future<IPojoFactory> m_future;
    private boolean m_frozen;

    public ManagedType(BundleContext bundleContext, QueueService queueService, TypeDeclaration declaration) {
        this.m_bundleContext = bundleContext;
        this.m_queueService = queueService;
        this.m_declaration = declaration;
        try {
            this.initExtensionTracker();
            this.initInstanceTracker();
        }
        catch (InvalidSyntaxException e) {
            this.m_frozen = true;
            this.m_declaration.unbind("Filter creation error", e);
        }
    }

    private void initExtensionTracker() throws InvalidSyntaxException {
        String filter = String.format("(&(objectclass=%s)(%s=%s))", ExtensionDeclaration.class.getName(), "ipojo.extension.name", this.m_declaration.getExtension());
        this.m_extensionTracker = new ServiceTracker(this.m_bundleContext, this.m_bundleContext.createFilter(filter), (ServiceTrackerCustomizer)new ExtensionSupport());
    }

    private void initInstanceTracker() throws InvalidSyntaxException {
        String version = this.m_declaration.getComponentVersion();
        String filter = version != null ? String.format("(&(objectClass=%s)(|(%s=%s)(%s=%s))(|(%s=%s)(!(%s=*))))", InstanceDeclaration.class.getName(), "ipojo.component.name", this.m_declaration.getComponentName(), "ipojo.component.name", this.getComponentClassname(), "ipojo.component.version", version, "ipojo.component.version") : String.format("(&(objectClass=%s)(|(%s=%s)(%s=%s))(!(%s=*)))", InstanceDeclaration.class.getName(), "ipojo.component.name", this.m_declaration.getComponentName(), "ipojo.component.name", this.getComponentClassname(), "ipojo.component.version");
        this.m_instanceTracker = new ServiceTracker(this.m_bundleContext, this.m_bundleContext.createFilter(filter), (ServiceTrackerCustomizer)new InstanceSupport());
    }

    private String getComponentClassname() {
        return this.m_declaration.getComponentMetadata().getAttribute("classname");
    }

    public void start() {
        if (!this.m_frozen) {
            this.m_extensionTracker.open(true);
        }
    }

    public void stop() {
        this.m_instanceTracker.close();
        this.m_extensionTracker.close();
    }

    public void stateChanged(Factory factory, int newState) {
        if (1 == newState) {
            this.m_instanceTracker.open(true);
        } else {
            this.m_instanceTracker.close();
        }
    }

    private class InstanceSupport
    implements ServiceTrackerCustomizer {
        private InstanceSupport() {
        }

        public Object addingService(final ServiceReference reference) {
            Object service = ManagedType.this.m_bundleContext.getService(reference);
            if (service instanceof InstanceDeclaration) {
                final InstanceDeclaration instanceDeclaration = (InstanceDeclaration)service;
                if (instanceDeclaration.getStatus().isBound()) {
                    return null;
                }
                if (!ManagedType.this.m_declaration.isPublic() && !reference.getBundle().equals(ManagedType.this.m_bundleContext.getBundle())) {
                    Bundle origin = ManagedType.this.m_bundleContext.getBundle();
                    instanceDeclaration.unbind(String.format("Component '%s/%s' is private. It only accept instances from bundle %s/%s [%d] (instance bundle origin: %d)", ManagedType.this.m_declaration.getComponentName(), ManagedType.this.m_declaration.getComponentVersion(), origin.getSymbolicName(), origin.getVersion(), origin.getBundleId(), reference.getBundle().getBundleId()));
                    return null;
                }
                return ManagedType.this.m_queueService.submit(new DefaultJob<ComponentInstance>(reference.getBundle(), ManagedType.INSTANCE_STARTUP_JOB_TYPE){

                    @Override
                    public ComponentInstance call() throws Exception {
                        try {
                            ComponentInstance instance = ((IPojoFactory)ManagedType.this.m_future.get()).createComponentInstance(instanceDeclaration.getConfiguration());
                            if (instance instanceof InstanceBundleContextAware) {
                                ((InstanceBundleContextAware)((Object)instance)).setInstanceBundleContext(instanceDeclaration.getBundle().getBundleContext());
                            }
                            instanceDeclaration.bind();
                            return instance;
                        }
                        catch (UnacceptableConfiguration c) {
                            instanceDeclaration.unbind(String.format("Instance configuration is invalid (component:%s/%s, bundle:%d)", ManagedType.this.m_declaration.getComponentName(), ManagedType.this.m_declaration.getComponentVersion(), reference.getBundle().getBundleId()), c);
                        }
                        catch (MissingHandlerException e) {
                            instanceDeclaration.unbind(String.format("Component '%s/%s' (required for instance creation) is missing some handlers", ManagedType.this.m_declaration.getComponentName(), ManagedType.this.m_declaration.getComponentVersion()), e);
                        }
                        catch (ConfigurationException e) {
                            instanceDeclaration.unbind(String.format("Instance configuration is incorrect for component '%s/%s'", ManagedType.this.m_declaration.getComponentName(), ManagedType.this.m_declaration.getComponentVersion()), e);
                        }
                        return null;
                    }
                }, String.format("Creating component instance of type %s (declaration from bundle %d)", ManagedType.this.m_declaration.getComponentName(), reference.getBundle().getBundleId()));
            }
            return null;
        }

        public void modifiedService(ServiceReference reference, Object o) {
        }

        public void removedService(ServiceReference reference, Object o) {
            InstanceDeclaration instanceDeclaration = (InstanceDeclaration)ManagedType.this.m_bundleContext.getService(reference);
            Future future = (Future)o;
            try {
                ComponentInstance instance = (ComponentInstance)future.get();
                if (instance != null) {
                    String message = String.format("Factory for Component '%s/%s' is missing", instance.getFactory().getName(), ManagedType.this.m_declaration.getComponentVersion());
                    instanceDeclaration.unbind(message);
                    instance.stop();
                    instance.dispose();
                }
            }
            catch (InterruptedException e) {
                instanceDeclaration.unbind("Could not create ComponentInstance", e);
            }
            catch (ExecutionException e) {
                instanceDeclaration.unbind("ComponentInstance creation throw an Exception", e);
            }
        }
    }

    private class ExtensionSupport
    implements ServiceTrackerCustomizer {
        private ExtensionSupport() {
        }

        public Object addingService(ServiceReference reference) {
            final Object service = ManagedType.this.m_bundleContext.getService(reference);
            if (service instanceof ExtensionDeclaration) {
                ManagedType.this.m_future = ManagedType.this.m_queueService.submit(new DefaultJob<IPojoFactory>(reference.getBundle(), ManagedType.FACTORY_CREATION_JOB_TYPE){

                    @Override
                    public IPojoFactory call() throws Exception {
                        ExtensionDeclaration declaration = (ExtensionDeclaration)service;
                        try {
                            IPojoFactory factory = declaration.getFactoryBuilder().build(ManagedType.this.m_bundleContext, ManagedType.this.m_declaration.getComponentMetadata());
                            factory.addFactoryStateListener(ManagedType.this);
                            factory.start();
                            ManagedType.this.m_declaration.bind();
                            return factory;
                        }
                        catch (FactoryBuilderException e) {
                            ManagedType.this.m_declaration.unbind(String.format("Cannot build '%s' factory instance", ManagedType.this.m_declaration.getExtension()), e);
                        }
                        catch (Throwable t) {
                            ManagedType.this.m_declaration.unbind(String.format("Error during '%s' factory instance creation", ManagedType.this.m_declaration.getExtension()), t);
                        }
                        return null;
                    }
                }, String.format("Building Factory for type %s", ManagedType.this.m_declaration.getComponentName()));
                return service;
            }
            return null;
        }

        public void modifiedService(ServiceReference reference, Object o) {
        }

        public void removedService(ServiceReference reference, Object o) {
            ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)o;
            try {
                IPojoFactory factory = (IPojoFactory)ManagedType.this.m_future.get();
                if (factory != null) {
                    factory.removeFactoryStateListener(ManagedType.this);
                    factory.dispose();
                    ManagedType.this.m_declaration.unbind(String.format("Extension '%s' is missing", extensionDeclaration.getExtensionName()));
                }
            }
            catch (InterruptedException e) {
                ManagedType.this.m_declaration.unbind("Could not create Factory", e);
            }
            catch (ExecutionException e) {
                ManagedType.this.m_declaration.unbind("Factory creation throw an Exception", e);
            }
            ManagedType.this.m_future = null;
        }
    }
}

