/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.ant;

import aQute.bnd.ant.BaseTask;
import aQute.bnd.build.Project;
import aQute.bnd.build.Workspace;
import aQute.lib.osgi.Builder;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.eclipse.EclipseClasspath;
import aQute.libg.qtokens.QuotedTokenizer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BndTask
extends BaseTask {
    String command;
    File basedir;
    boolean failok;
    boolean exceptions;
    boolean print;
    private boolean classpathDirectlySet;
    private Path classpathReference;
    private Path bndfilePath;
    List<File> files = new ArrayList<File>();
    List<File> classpath = new ArrayList<File>();
    List<File> sourcepath = new ArrayList<File>();
    File output = null;
    File testDir = null;
    boolean eclipse;
    boolean inherit = true;
    static File[] EMPTY_FILES = new File[0];

    public void execute() throws BuildException {
        this.validate();
        this.updateClasspath();
        this.updateBndFiles();
        if (this.command == null) {
            this.executeBackwardCompatible();
            return;
        }
        if (this.basedir == null) {
            throw new BuildException("No basedir set");
        }
        try {
            Project project = Workspace.getProject(this.basedir);
            project.setProperty("in.ant", "true");
            project.setProperty("environment", "ant");
            project.setExceptions(true);
            project.setTrace(this.trace);
            project.setPedantic(this.pedantic);
            project.action(this.command);
            if (this.report(project)) {
                throw new BuildException("Command " + this.command + " failed");
            }
        }
        catch (Throwable e) {
            if (this.exceptions) {
                e.printStackTrace();
            }
            throw new BuildException(e);
        }
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    private void executeBackwardCompatible() throws BuildException {
        block18: {
            try {
                if (this.files == null) {
                    throw new BuildException("No files set");
                }
                if (this.eclipse) {
                    File project = this.getProject().getBaseDir();
                    EclipseClasspath cp = new EclipseClasspath(this, project.getParentFile(), project);
                    this.classpath.addAll(cp.getClasspath());
                    this.classpath.addAll(cp.getBootclasspath());
                    this.sourcepath.addAll(cp.getSourcepath());
                    if (this.report()) {
                        throw new BuildException("Errors during Eclipse Path inspection");
                    }
                }
                if (this.output == null) {
                    this.output = this.getProject().getBaseDir();
                }
                for (File file : this.files) {
                    Builder builder = new Builder();
                    builder.setPedantic(this.isPedantic());
                    if (file.exists()) {
                        builder.setProperties(file);
                    }
                    if (this.inherit) {
                        Properties projectProperties = new Properties();
                        projectProperties.putAll((Map<?, ?>)this.getProject().getProperties());
                        projectProperties.putAll((Map<?, ?>)builder.getProperties());
                        builder.setProperties(projectProperties);
                    }
                    builder.setClasspath(this.toFiles(this.classpath, "classpath"));
                    builder.setSourcepath(this.toFiles(this.sourcepath, "sourcepath"));
                    Jar[] jars = builder.builds();
                    if (!this.failok && this.report() && this.report(builder)) {
                        throw new BuildException("bnd failed", new Location(file.getAbsolutePath()));
                    }
                    int i = 0;
                    while (i < jars.length) {
                        Jar jar = jars[i];
                        String bsn = jar.getName();
                        File base = file.getParentFile();
                        File output = this.output;
                        String path = builder.getProperty("-output");
                        if (output == null) {
                            output = path == null ? BndTask.getFile(base, String.valueOf(bsn) + ".jar") : BndTask.getFile(base, path);
                        } else if (output.isDirectory()) {
                            output = path == null ? BndTask.getFile(this.output, String.valueOf(bsn) + ".jar") : BndTask.getFile(this.output, path);
                        } else if (output.isFile() && this.files.size() > 1) {
                            this.error("Output is a file but there are multiple input files, these files will overwrite the output file: " + output.getAbsolutePath(), new Object[0]);
                        }
                        String msg = "";
                        if (!output.exists() || output.lastModified() <= jar.lastModified()) {
                            jar.write(output);
                        } else {
                            msg = "(not modified)";
                        }
                        this.trace(String.valueOf(jar.getName()) + " (" + output.getName() + ") " + jar.getResources().size() + " " + msg, new Object[0]);
                        this.report();
                        jar.close();
                        ++i;
                    }
                    builder.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.failok) break block18;
                throw new BuildException("Failed to build jar file: ", (Throwable)e);
            }
        }
    }

    public void setFiles(String files) {
        files = files.replaceAll("\\.jar(,|$)", ".bnd");
        this.addAll(this.files, files, ",");
    }

    void addAll(List<File> list, String files, String separator) {
        this.trace("addAll '%s' with %s", files, separator);
        QuotedTokenizer qt = new QuotedTokenizer(files, separator);
        String[] entries = qt.getTokens();
        File project = this.getProject().getBaseDir();
        int i = 0;
        while (i < entries.length) {
            File f = BndTask.getFile(project, entries[i]);
            if (f.exists()) {
                list.add(f);
            } else {
                this.error("Can not find bnd file to process: " + f.getAbsolutePath(), new Object[0]);
            }
            ++i;
        }
    }

    public void setClasspath(String value) {
        Path p = (Path)this.getProject().getReference(value);
        if (p == null) {
            this.addAll(this.classpath, value, String.valueOf(File.pathSeparator) + ",");
        } else {
            String[] path = p.list();
            int i = 0;
            while (i < path.length) {
                this.classpath.add(new File(path[i]));
                ++i;
            }
        }
        this.classpathDirectlySet = true;
    }

    public void setEclipse(boolean eclipse) {
        this.eclipse = eclipse;
    }

    boolean isFailok() {
        return this.failok;
    }

    public void setFailok(boolean failok) {
        this.failok = failok;
    }

    boolean isExceptions() {
        return this.exceptions;
    }

    public void setExceptions(boolean exceptions) {
        this.exceptions = exceptions;
    }

    boolean isPrint() {
        return this.print;
    }

    void setPrint(boolean print) {
        this.print = print;
    }

    public void setSourcepath(String sourcepath) {
        this.addAll(this.sourcepath, sourcepath, String.valueOf(File.pathSeparator) + ",");
    }

    File[] toFiles(List<File> files, String what) throws IOException {
        return files.toArray(EMPTY_FILES);
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void setDestFile(File output) {
        this.output = output;
    }

    public void setTestDir(File testDir) {
        this.testDir = testDir;
    }

    public void setInherit(boolean inherit) {
        this.inherit = inherit;
    }

    public void setClasspathref(Reference reference) {
        this.classpathReference = this.createPath(reference);
    }

    public void setBndfilePath(Reference reference) {
        this.assertPathNotSet(this.bndfilePath, "bnd files are already set");
        this.bndfilePath = this.createPath(reference);
    }

    public void addClasspath(Path path) {
        this.assertPathNotSet(this.classpathReference, "Classpath reference is already set");
        this.classpathReference = path;
    }

    public void addBndfiles(Path path) {
        this.assertPathNotSet(this.bndfilePath, "bnd files are already set");
        this.bndfilePath = path;
    }

    private Path createPath(Reference r) {
        Path path = new Path(this.getProject()).createPath();
        path.setRefid(r);
        return path;
    }

    private void assertPathNotSet(Path path, String message) {
        if (path != null) {
            throw new BuildException(message);
        }
    }

    protected void validate() {
        if (this.classpath == null && this.classpathReference == null) {
            this.log("Unable to get a classpath ...attributes not set");
            throw new BuildException("No one of the classpath or classpathref defined...");
        }
        if (this.classpathDirectlySet && this.classpathReference != null) {
            this.log("Unable to choose between classpath & classpathref !!");
            throw new BuildException("Can't choose between classpath & classpathref");
        }
    }

    private void updateClasspath() {
        this.log("Updating classpath after classpathref setting");
        if (this.classpathReference == null) {
            return;
        }
        this.addFilesFrom(this.classpathReference, this.classpath);
    }

    private void updateBndFiles() {
        if (this.bndfilePath == null) {
            return;
        }
        this.addFilesFrom(this.bndfilePath, this.files);
    }

    private void addFilesFrom(Path path, List<File> files) {
        String[] stringArray = path.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            files.add(new File(fileName.replace('\\', '/')));
            ++n2;
        }
    }
}

