/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.util;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceRegistration;

public class SecurityHelper {
    public static BundleContext selectContextToRegisterServices(String[] itfs, BundleContext comp, BundleContext ipojo) {
        if (System.getSecurityManager() != null) {
            for (String itf : itfs) {
                ServicePermission perm = new ServicePermission(itf, "register");
                if (comp.getBundle().hasPermission((Object)perm)) continue;
                return ipojo;
            }
        }
        return comp;
    }

    public static BundleContext selectContextToRegisterService(String itf, BundleContext comp, BundleContext ipojo) {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(itf, "register");
            if (!comp.getBundle().hasPermission((Object)perm)) {
                return ipojo;
            }
        }
        return comp;
    }

    public static BundleContext selectContextToGetService(String itf, BundleContext comp, BundleContext ipojo) {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(itf, "get");
            if (!comp.getBundle().hasPermission((Object)perm)) {
                return ipojo;
            }
        }
        return comp;
    }

    public static boolean hasPermissionToGetService(String itf, BundleContext comp) {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(itf, "get");
            return comp.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    public static boolean hasPermissionToGetServices(String[] itfs, BundleContext comp) {
        if (System.getSecurityManager() != null) {
            for (String itf : itfs) {
                ServicePermission perm = new ServicePermission(itf, "get");
                if (comp.getBundle().hasPermission((Object)perm)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean hasPermissionToRegisterService(String itf, BundleContext comp) {
        if (System.getSecurityManager() != null) {
            ServicePermission perm = new ServicePermission(itf, "register");
            return comp.getBundle().hasPermission((Object)perm);
        }
        return true;
    }

    public static boolean hasPermissionToRegisterServices(String[] itfs, BundleContext comp) {
        if (System.getSecurityManager() != null) {
            for (String itf : itfs) {
                ServicePermission perm = new ServicePermission(itf, "register");
                if (comp.getBundle().hasPermission((Object)perm)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canRegisterService(BundleContext context) {
        return context.getBundle().getState() == 32 || context.getBundle().getState() == 8;
    }

    public static boolean canUpdateService(ServiceRegistration registration) {
        if (registration == null) {
            return false;
        }
        try {
            BundleContext context = registration.getReference().getBundle().getBundleContext();
            return context.getBundle().getState() == 32 || context.getBundle().getState() == 8;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

