/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.ipojo.annotations.HandlerBinding;
import org.apache.felix.ipojo.annotations.Ignore;
import org.apache.felix.ipojo.annotations.Stereotype;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.ResourceStore;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.AnnotationType;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.discovery.ChainedAnnotationDiscovery;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.discovery.HandlerBindingDiscovery;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.discovery.IgnoredDiscovery;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.discovery.StereotypeDiscovery;
import org.apache.felix.ipojo.manipulator.metadata.annotation.model.parser.AnnotationParser;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.Binding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.BindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.registry.CompletableBindingRegistry;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.generic.GenericVisitorFactory;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.ignore.NullBinding;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.stereotype.StereotypeVisitorFactory;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.util.Elements;
import org.apache.felix.ipojo.manipulator.spi.helper.Predicates;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.Type;

public class MetaAnnotationBindingRegistry
extends CompletableBindingRegistry {
    private ResourceStore m_store;
    private Reporter m_reporter;

    public MetaAnnotationBindingRegistry(BindingRegistry delegate, Reporter reporter, ResourceStore store) {
        super(delegate, reporter);
        this.m_reporter = reporter;
        this.m_store = store;
        this.addBindings(this.nullBindingsForMetaAnnotations());
    }

    protected Iterable<Binding> nullBindingsForMetaAnnotations() {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        bindings.add(new NullBinding(Type.getType(Stereotype.class)));
        bindings.add(new NullBinding(Type.getType(HandlerBinding.class)));
        bindings.add(new NullBinding(Type.getType(Ignore.class)));
        return bindings;
    }

    @Override
    protected List<Binding> createBindings(Type type) {
        Binding binding;
        byte[] bytes;
        try {
            bytes = this.m_store.read(type.getInternalName().concat(".class"));
        }
        catch (IOException e) {
            this.m_reporter.trace("Could not read bytecode for @%s.", type.getClassName());
            return Collections.emptyList();
        }
        catch (IllegalStateException e) {
            this.m_reporter.trace("Could not read bytecode for @%s because the bundle is not in a state allowing read operations.", type.getClassName());
            return Collections.emptyList();
        }
        AnnotationParser parser = new AnnotationParser();
        AnnotationType annotationType = parser.read(bytes);
        ChainedAnnotationDiscovery chain = new ChainedAnnotationDiscovery();
        StereotypeDiscovery stereotypeDiscovery = new StereotypeDiscovery();
        HandlerBindingDiscovery handlerBindingDiscovery = new HandlerBindingDiscovery();
        IgnoredDiscovery ignoredDiscovery = new IgnoredDiscovery();
        chain.getDiscoveries().add(stereotypeDiscovery);
        chain.getDiscoveries().add(handlerBindingDiscovery);
        chain.getDiscoveries().add(ignoredDiscovery);
        annotationType.traverse(chain);
        List<Binding> bindings = new ArrayList<Binding>();
        if (stereotypeDiscovery.isStereotype()) {
            this.m_reporter.trace("@Stereotype detected: @%s", type.getClassName());
            binding = new Binding();
            binding.setAnnotationType(type);
            binding.setPredicate(Predicates.alwaysTrue());
            binding.setFactory(new StereotypeVisitorFactory(annotationType));
            bindings.add(binding);
        }
        if (handlerBindingDiscovery.isHandlerBinding()) {
            this.m_reporter.trace("@HandlerBinding detected: @%s", type.getClassName());
            binding = new Binding();
            binding.setAnnotationType(type);
            binding.setPredicate(Predicates.alwaysTrue());
            Element element = this.buildElement(handlerBindingDiscovery, type);
            binding.setFactory(new GenericVisitorFactory(element.getName(), element.getNameSpace()));
            bindings.add(binding);
        }
        if (ignoredDiscovery.isIgnore()) {
            this.m_reporter.trace("@Ignore detected: @%s", type.getClassName());
            binding = new NullBinding(type);
            bindings.clear();
            bindings.add(binding);
            bindings = Collections.unmodifiableList(bindings);
        }
        return bindings;
    }

    private Element buildElement(HandlerBindingDiscovery handler, Type type) {
        Element element = handler.getNamespace() == null && handler.getValue() == null ? Elements.buildElement(type) : (handler.getNamespace() == null ? Elements.buildElement(handler.getValue()) : Elements.buildElement(handler.getNamespace(), handler.getValue()));
        return element;
    }
}

