/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.test.scenarios.component.ProvidesSimple;

public class OptionalDependency
extends OSGiTestCase {
    private Element[] deps;
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.OptionalDependency");
        this.deps = meta.getElements("requires");
    }

    public void testField() {
        Element dep = this.getDependencyById(this.deps, "fs");
        String opt = dep.getAttribute("optional");
        OptionalDependency.assertEquals((String)"Check optionality", (String)"true", (String)opt);
    }

    public void testFieldNoOptional() {
        Element dep = this.getDependencyById(this.deps, "fs2");
        String opt = dep.getAttribute("optional");
        OptionalDependency.assertEquals((String)"Check optionality", (String)"false", (String)opt);
    }

    public void testCallbackBind() {
        Element dep = this.getDependencyById(this.deps, "Bar");
        String opt = dep.getAttribute("optional");
        OptionalDependency.assertEquals((String)"Check optionality", (String)"true", (String)opt);
    }

    public void testCallbackUnbind() {
        Element dep = this.getDependencyById(this.deps, "Baz");
        String opt = dep.getAttribute("optional");
        OptionalDependency.assertEquals((String)"Check optionality", (String)"true", (String)opt);
    }

    public void testBoth() {
        Element dep = this.getDependencyById(this.deps, "inv");
        String opt = dep.getAttribute("optional");
        OptionalDependency.assertEquals((String)"Check optionality", (String)"true", (String)opt);
    }

    public void testBindOnly() {
        Element dep = this.getDependencyById(this.deps, "bindonly");
        String opt = dep.getAttribute("optional");
        OptionalDependency.assertEquals((String)"Check optionality", (String)"true", (String)opt);
    }

    public void testUnbindOnly() {
        Element dep = this.getDependencyById(this.deps, "unbindonly");
        String opt = dep.getAttribute("optional");
        OptionalDependency.assertEquals((String)"Check optionality", (String)"true", (String)opt);
    }

    public void testNullable() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.NullableDependency");
        Element[] deps = meta.getElements("requires");
        Element fs = this.getDependencyById(deps, "fs");
        String nullable = fs.getAttribute("nullable");
        OptionalDependency.assertNotNull((String)"Check nullable", (Object)nullable);
        OptionalDependency.assertEquals((String)"Check nullable value", (String)"true", (String)nullable);
    }

    public void testNoNullable() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.NullableDependency");
        Element[] deps = meta.getElements("requires");
        Element fs = this.getDependencyById(deps, "fs2");
        String nullable = fs.getAttribute("nullable");
        OptionalDependency.assertNotNull((String)"Check nullable", (Object)nullable);
        OptionalDependency.assertEquals((String)"Check nullable value", (String)"false", (String)nullable);
    }

    public void testDefaultImplmentation() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.DefaultImplementationDependency");
        Element[] deps = meta.getElements("requires");
        Element fs = this.getDependencyById(deps, "fs");
        String di = fs.getAttribute("default-implementation");
        OptionalDependency.assertNotNull((String)"Check DI", (Object)di);
        OptionalDependency.assertEquals((String)"Check DI value", (String)ProvidesSimple.class.getName(), (String)di);
    }

    private Element getDependencyById(Element[] deps, String name) {
        int i = 0;
        while (i < deps.length) {
            String na = deps[i].getAttribute("id");
            String field = deps[i].getAttribute("field");
            if (na != null && na.equalsIgnoreCase(name)) {
                return deps[i];
            }
            if (field != null && field.equalsIgnoreCase(name)) {
                return deps[i];
            }
            ++i;
        }
        OptionalDependency.fail((String)("Dependency  " + name + " not found"));
        return null;
    }
}

