/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.online.manipulator;

import java.io.PrintStream;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class SystemLogService
implements LogService {
    public void log(int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(int level, String message, Throwable throwable) {
        this.log(null, level, message, throwable);
    }

    public void log(ServiceReference reference, int level, String message) {
        this.log(null, level, message, null);
    }

    public void log(ServiceReference reference, int level, String message, Throwable throwable) {
        PrintStream stream = System.out;
        if (level >= 2) {
            stream = System.err;
        }
        String formatted = String.format("%s %s", SystemLogService.asString(level), message);
        if (reference != null) {
            formatted = String.format("[%s] %s", reference.getBundle().getSymbolicName(), formatted);
        }
        stream.println(formatted);
        if (throwable != null) {
            throwable.printStackTrace(stream);
        }
    }

    private static String asString(int level) {
        String levelStr = "?";
        switch (level) {
            case 4: {
                levelStr = "D";
                break;
            }
            case 3: {
                levelStr = "I";
                break;
            }
            case 2: {
                levelStr = "W";
                break;
            }
            case 1: {
                levelStr = "E";
            }
        }
        return levelStr;
    }
}

