/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.jaas.internal;

import java.util.Collections;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.spi.LoginModule;
import org.apache.felix.jaas.LoginModuleFactory;
import org.apache.felix.jaas.internal.ControlFlag;
import org.apache.felix.jaas.internal.LoginModuleProvider;
import org.apache.felix.jaas.internal.Util;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;

final class OsgiLoginModuleProvider
implements LoginModuleProvider {
    private final LoginModuleFactory delegate;
    private final ServiceReference serviceReference;
    private int ranking;
    private AppConfigurationEntry.LoginModuleControlFlag flag;
    private String realmName;

    public OsgiLoginModuleProvider(ServiceReference sr, LoginModuleFactory delegate) {
        this.delegate = delegate;
        this.serviceReference = sr;
        this.configure();
    }

    public void configure() {
        Object rankingProperty = this.serviceReference.getProperty("jaas.ranking");
        if (rankingProperty == null) {
            rankingProperty = this.serviceReference.getProperty("service.ranking");
        }
        this.ranking = PropertiesUtil.toInteger(rankingProperty, 0);
        this.flag = ControlFlag.from((String)this.serviceReference.getProperty("jaas.controlFlag")).flag();
        this.realmName = Util.trimToNull((String)this.serviceReference.getProperty("jaas.realmName"));
    }

    @Override
    public Map<String, ?> options() {
        return Collections.emptyMap();
    }

    @Override
    public AppConfigurationEntry.LoginModuleControlFlag getControlFlag() {
        return this.flag;
    }

    @Override
    public int ranking() {
        return this.ranking;
    }

    @Override
    public String realmName() {
        return this.realmName;
    }

    @Override
    public LoginModule createLoginModule() {
        return this.delegate.createLoginModule();
    }

    @Override
    public String getClassName() {
        return this.delegate.getClass().getName();
    }

    public ServiceReference getServiceReference() {
        return this.serviceReference;
    }

    public String toString() {
        return "OsgiLoginModuleProvider{className=" + this.delegate.getClass().getName() + ", ranking=" + this.ranking + ", flag=" + this.flag + ", realmName='" + this.realmName + '\'' + '}';
    }
}

