/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.basedriver.export;

import java.util.Dictionary;
import java.util.Properties;
import org.apache.felix.upnp.basedriver.Activator;
import org.apache.felix.upnp.basedriver.util.Converter;
import org.cybergarage.upnp.Action;
import org.cybergarage.upnp.Argument;
import org.cybergarage.upnp.ArgumentList;
import org.cybergarage.upnp.control.ActionListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPException;
import org.osgi.service.upnp.UPnPService;

public class GeneralActionListener
implements ServiceListener,
ActionListener {
    private ServiceReference dev;
    private String id;
    private boolean open;

    public GeneralActionListener(ServiceReference sr, String serviceId) {
        try {
            Activator.bc.addServiceListener((ServiceListener)this, "(service.id=" + sr.getProperty("service.id") + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            // empty catch block
        }
        this.dev = sr;
        this.id = serviceId;
        this.open = true;
    }

    public synchronized boolean actionControlReceived(Action upnpAct) {
        if (!this.open) {
            return false;
        }
        UPnPService osgiServ = null;
        try {
            osgiServ = ((UPnPDevice)Activator.bc.getService(this.dev)).getService(this.id);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (osgiServ == null) {
            return this.exiting(false);
        }
        UPnPAction osgiAct = osgiServ.getAction(upnpAct.getName());
        Properties inArgs = null;
        ArgumentList alIn = upnpAct.getInputArgumentList();
        ArgumentList alOut = upnpAct.getOutputArgumentList();
        String[] inArg = osgiAct.getInputArgumentNames();
        boolean invalidAction = false;
        if (inArg != null) {
            inArgs = new Properties();
            for (int j = 0; j < inArg.length; ++j) {
                Argument arg = alIn.getArgument(inArg[j]);
                try {
                    inArgs.put(inArg[j], Converter.parseString(arg.getValue(), arg.getRelatedStateVariable().getDataType()));
                    continue;
                }
                catch (Exception e) {
                    invalidAction = true;
                    break;
                }
            }
        }
        Dictionary outArgs = null;
        try {
            outArgs = osgiAct.invoke((Dictionary)inArgs);
        }
        catch (UPnPException e) {
            upnpAct.setStatus(e.getUPnPError_Code(), e.getMessage());
            invalidAction = true;
        }
        catch (Exception e) {
            upnpAct.setStatus(501);
            invalidAction = true;
        }
        if (invalidAction) {
            return this.exiting(false);
        }
        String[] outArg = osgiAct.getOutputArgumentNames();
        if (outArg != null) {
            for (int j = 0; j < outArg.length; ++j) {
                Argument arg = alOut.getArgument(outArg[j]);
                try {
                    arg.setValue(Converter.toString(outArgs.get(outArg[j]), arg.getRelatedStateVariable().getDataType()));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return this.exiting(false);
                }
            }
        }
        return this.exiting(true);
    }

    private boolean exiting(boolean b) {
        Activator.bc.ungetService(this.dev);
        return b;
    }

    public void serviceChanged(ServiceEvent e) {
        if (e.getType() == 4) {
            Activator.bc.removeServiceListener((ServiceListener)this);
        }
    }
}

