/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.discovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.upnp.UPnPDevice;

public class DeviceNode {
    private ServiceReference sr;
    private boolean isRootNode;
    private String udn;
    private boolean hasChild;
    private int numberOfSons;
    private ArrayList children;
    private DeviceNode parent;

    public DeviceNode(ServiceReference sr) {
        if (sr == null) {
            throw new IllegalArgumentException("null is not a valid arg in DeviceNode constructor");
        }
        this.sr = sr;
        this.udn = (String)sr.getProperty("UPnP.device.UDN");
        this.parent = null;
        this.isRootNode = sr.getProperty("UPnP.device.parentUDN") == null;
        String[] sons = (String[])sr.getProperty("UPnP.device.childrenUDN");
        boolean bl = this.hasChild = sons != null;
        if (this.hasChild) {
            this.children = new ArrayList();
            this.numberOfSons = sons.length;
        }
    }

    public ServiceReference getReference() {
        return this.sr;
    }

    public UPnPDevice getDevice(BundleContext ctx) {
        return (UPnPDevice)ctx.getService(this.sr);
    }

    public void attach(DeviceNode node) {
        if (node == null) {
            throw new IllegalArgumentException("null is not a valid arg in DeviceNode.attach() method");
        }
        node.parent = this;
        this.children.add(node);
    }

    public DeviceNode dethatch(String name) {
        DeviceNode dn = this.search(name);
        if (dn == null) {
            return null;
        }
        if (dn.parent != null) {
            Iterator list = dn.parent.children.iterator();
            while (list.hasNext()) {
                DeviceNode x = (DeviceNode)list.next();
                if (!x.udn.equals(name)) continue;
                list.remove();
                break;
            }
        }
        dn.parent = null;
        return dn;
    }

    public Collection getAllChildren() {
        if (this.children == null || this.children.size() == 0) {
            return new ArrayList();
        }
        Vector v = new Vector(this.children);
        Iterator list = this.children.iterator();
        while (list.hasNext()) {
            DeviceNode x = (DeviceNode)list.next();
            Collection c = x.getAllChildren();
            if (c == null) continue;
            v.addAll(c);
        }
        return v;
    }

    public Collection getChildren() {
        if (this.children == null || this.children.size() == 0) {
            return new ArrayList();
        }
        return this.children;
    }

    public DeviceNode search(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null is not a valid arg in DeviceNode.search() method");
        }
        if (name.equals(this.udn)) {
            return this;
        }
        if (this.hasChild) {
            Iterator list = this.children.iterator();
            while (list.hasNext()) {
                DeviceNode child = (DeviceNode)list.next();
                DeviceNode node = child.search(name);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public boolean contains(String udn) {
        return this.search(udn) != null;
    }

    public boolean isComplete() {
        if (!this.hasChild) {
            return true;
        }
        if (this.numberOfSons != this.children.size()) {
            return false;
        }
        Iterator list = this.children.iterator();
        while (list.hasNext()) {
            DeviceNode child = (DeviceNode)list.next();
            if (child.isComplete()) continue;
            return false;
        }
        return true;
    }

    public DeviceNode isAttachable(DeviceNode node) {
        if (node == null) {
            throw new IllegalArgumentException("null is not a valid arg in DeviceNode.isAttachable() method");
        }
        String parentUDN = (String)node.getReference().getProperty("UPnP.device.parentUDN");
        if (parentUDN == null) {
            return null;
        }
        return this.search(parentUDN);
    }

    public boolean isRoot() {
        return this.isRootNode;
    }

    public boolean equals(String udn) {
        return this.udn.equals(udn);
    }

    public String toString() {
        return this.udn;
    }

    public boolean isLeaf() {
        return !this.hasChild;
    }

    public void print() {
        System.out.println("####Device Node");
        String[] props = this.sr.getPropertyKeys();
        for (int i = 0; i < props.length; ++i) {
            Object prop = this.sr.getProperty(props[i]);
            if (prop instanceof String[]) {
                System.out.println(props[i] + "=");
                String[] multiple = (String[])prop;
                for (int j = 0; j < multiple.length; ++j) {
                    System.out.println(multiple[j] + ";");
                }
                continue;
            }
            System.out.println(props[i] + "=" + prop);
        }
        System.out.println("####Device Node");
    }
}

