/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.felix.upnp.tester.Activator;
import org.apache.felix.upnp.tester.Mediator;
import org.apache.felix.upnp.tester.discovery.DeviceNode;
import org.apache.felix.upnp.tester.discovery.DeviceNodeListener;
import org.apache.felix.upnp.tester.gui.PropertiesViewer;
import org.apache.felix.upnp.tester.gui.TreeNodeCellRenderer;
import org.apache.felix.upnp.tester.gui.TreePopup;
import org.apache.felix.upnp.tester.gui.UPnPDeviceTreeNode;
import org.apache.felix.upnp.tester.gui.Util;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPDevice;
import org.osgi.service.upnp.UPnPService;
import org.osgi.service.upnp.UPnPStateVariable;

public class TreeViewer
extends JPanel
implements DeviceNodeListener {
    private UPnPDeviceTreeNode root;
    private DefaultTreeModel treeModel;
    private JTree tree;
    final TreePopup popup;

    public TreeViewer() {
        super(new BorderLayout());
        Mediator.setTreeViewer(this);
        this.root = new UPnPDeviceTreeNode("UPnP Devices");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        Mediator.setUPnPDeviceTree(this.tree);
        this.tree.setCellRenderer(new TreeNodeCellRenderer());
        this.tree.putClientProperty("JTree.lineStyle", "Angled");
        this.add(new JScrollPane(this.tree));
        this.addTreeSelectionListener();
        this.popup = new TreePopup(this.tree);
        this.popup.setEnabled(false);
        this.tree.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    TreePath path = TreeViewer.this.tree.getClosestPathForLocation(e.getX(), e.getY());
                    TreeViewer.this.tree.setSelectionPath(path);
                    TreeViewer.this.tree.scrollPathToVisible(path);
                    TreeViewer.this.popup.show(TreeViewer.this.tree, e.getX(), e.getY());
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.tree);
    }

    public void setPopupMenuEnabled(boolean driverControllerAvailable) {
        this.popup.getComponent(0).setEnabled(driverControllerAvailable);
    }

    public void deviceDetected(DeviceNode node) {
        this.root.add(new UPnPDeviceTreeNode(node, Activator.context));
        this.treeModel.nodeStructureChanged(this.root);
    }

    public void rootDeviceUnplugged(String udn) {
        Enumeration<TreeNode> list = this.root.children();
        while (list.hasMoreElements()) {
            UPnPDeviceTreeNode node = (UPnPDeviceTreeNode)list.nextElement();
            DeviceNode device = (DeviceNode)node.getUserObject();
            if (!udn.equals(device.toString())) continue;
            node.removeFromParent();
            this.treeModel.nodeStructureChanged(this.root);
        }
    }

    private void addTreeSelectionListener() {
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                UPnPDeviceTreeNode selectedNode = (UPnPDeviceTreeNode)TreeViewer.this.tree.getLastSelectedPathComponent();
                TreeViewer.this.doNodeAction(selectedNode);
            }
        });
    }

    private void doNodeAction(UPnPDeviceTreeNode node) {
        if (node == null) {
            this.clearPropertiesViewer();
            return;
        }
        if (node.category.equals("UPnPAction")) {
            Mediator.getPropertiesViewer().showActionPanel(true);
        } else {
            Mediator.getPropertiesViewer().showActionPanel(false);
        }
        if (node.category.equals("UPnPService")) {
            Mediator.getPropertiesViewer().showSubscriptionPanel(true);
        } else {
            Mediator.getPropertiesViewer().showSubscriptionPanel(false);
        }
        if (node.category.equals("DeviceNode") || node.category.equals("RootDeviceNode")) {
            DeviceNode device = (DeviceNode)node.getUserObject();
            UPnPDevice upnpDevice = device.getDevice(Activator.context);
            this.makeProperties(upnpDevice);
        } else if (node.category.equals("UPnPService")) {
            UPnPService service = (UPnPService)node.getUserObject();
            this.makeProperties(service);
        } else if (node.category.equals("UPnPAction")) {
            UPnPAction action = (UPnPAction)node.getUserObject();
            this.makeProperties(action);
            Mediator.getPropertiesViewer().setAction(action);
        } else if (node.category.equals("UPnPStateVariable") || node.category.equals("EventedStateVariable") || node.category.equals("SubscribedStateVariable")) {
            UPnPStateVariable state = (UPnPStateVariable)node.getUserObject();
            this.makeProperties(state);
        }
    }

    private void clearPropertiesViewer() {
        String[] names = new String[]{};
        String[] values = new String[]{};
        PropertiesViewer viewer = Mediator.getPropertiesViewer();
        viewer.setProperties(names, values);
        viewer.showActionPanel(false);
        viewer.showSubscriptionPanel(false);
    }

    private void makeProperties(UPnPDevice upnpDevice) {
        Dictionary dict = upnpDevice.getDescriptions(null);
        int size = dict.size();
        String[] names = new String[size];
        String[] values = new String[size];
        Enumeration keys = dict.keys();
        for (int i = 0; i < size; ++i) {
            names[i] = (String)keys.nextElement();
            values[i] = Util.justString(dict.get(names[i]));
        }
        Mediator.getPropertiesViewer().setProperties(names, values);
    }

    private void makeProperties(UPnPService service) {
        String[] names = new String[]{"Id", "Type", "Version"};
        String[] values = new String[]{service.getId(), service.getType(), service.getType()};
        Mediator.getPropertiesViewer().setProperties(names, values);
    }

    private void makeProperties(UPnPAction action) {
        String[] outArg;
        String[] inArg;
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        names.add("Name");
        values.add(action.getName());
        String returnName = action.getReturnArgumentName();
        if (returnName != null) {
            names.add("Return value name");
            values.add(returnName);
        }
        if ((inArg = action.getInputArgumentNames()) != null) {
            for (int i = 0; i < inArg.length; ++i) {
                names.add("Input arg[" + (i + 1) + "]");
                values.add(inArg[i]);
            }
        }
        if ((outArg = action.getOutputArgumentNames()) != null) {
            for (int i = 0; i < outArg.length; ++i) {
                names.add("Output arg[" + (i + 1) + "]");
                values.add(outArg[i]);
            }
        }
        Mediator.getPropertiesViewer().setProperties(names.toArray(new String[0]), values.toArray(new String[0]));
    }

    private void makeProperties(UPnPStateVariable state) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        names.add("Name");
        values.add(state.getName());
        names.add("Evented");
        values.add(state.sendsEvents() ? "yes" : "no");
        names.add("Default Value");
        values.add(Util.justString(state.getDefaultValue()));
        names.add("Java Data Type");
        values.add(state.getJavaDataType().getName());
        names.add("Java UPnP Type");
        values.add(state.getUPnPDataType());
        names.add("Minimum");
        values.add(Util.justString(state.getMinimum()));
        names.add("Maximum");
        values.add(Util.justString(state.getMaximum()));
        names.add("Step");
        values.add(Util.justString(state.getStep()));
        String[] allowed = state.getAllowedValues();
        if (allowed != null) {
            for (int i = 0; i < allowed.length; ++i) {
                names.add("Allowed value[" + i + 1 + "]");
                values.add(allowed[i]);
            }
        }
        Mediator.getPropertiesViewer().setProperties(names.toArray(new String[0]), values.toArray(new String[0]));
    }
}

