/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.felix.webconsole.bundleinfo.BundleInfo;
import org.apache.felix.webconsole.bundleinfo.BundleInfoProvider;
import org.apache.felix.webconsole.bundleinfo.BundleInfoType;
import org.apache.felix.webconsole.i18n.LocalizationHelper;
import org.apache.felix.webconsole.internal.core.CapabilitiesPrinter;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleWiring;

public class CapabilitiesProvidedInfoProvider
implements BundleInfoProvider {
    private final LocalizationHelper localization;
    private static final List<String> STANDARD_NAMESPACES = Arrays.asList("osgi.wiring.bundle", "osgi.identity");

    CapabilitiesProvidedInfoProvider(Bundle bundle) {
        this.localization = new LocalizationHelper(bundle);
    }

    @Override
    public String getName(Locale locale) {
        return this.localization.getResourceBundle(locale).getString("capabilities.provided.info.name");
    }

    @Override
    public BundleInfo[] getBundleInfo(Bundle bundle, String webConsoleRoot, Locale locale) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring == null) {
            return new BundleInfo[0];
        }
        CapabilityFilter capabilityFilter = new CapabilityFilter(wiring);
        List capabilities = wiring.getCapabilities(null);
        if (capabilities == null) {
            return new BundleInfo[0];
        }
        List filteredCapabilities = capabilities.stream().filter(capabilityFilter).collect(Collectors.toList());
        return (BundleInfo[])filteredCapabilities.stream().map(c -> this.toInfo((BundleCapability)c, wiring, webConsoleRoot, locale)).toArray(BundleInfo[]::new);
    }

    private BundleInfo toInfo(BundleCapability capability, BundleWiring wiring, String webConsoleRoot, Locale locale) {
        String descr = this.localization.getResourceBundle(locale).getString("capabilities.provided.info.descr");
        String name = this.localization.getResourceBundle(locale).getString("capabilities.provided.info.key");
        String requirerBundles = wiring.getProvidedWires(capability.getNamespace()).stream().map(w -> w.getRequirer().getSymbolicName() + " (" + w.getRequirer().getBundle().getBundleId() + ")").collect(Collectors.joining(", "));
        name = MessageFormat.format(name, capability.getNamespace(), CapabilitiesPrinter.dumpTypedAttributes(capability.getAttributes()));
        if (!requirerBundles.isEmpty()) {
            name = name + MessageFormat.format(this.localization.getResourceBundle(locale).getString("capabilities.provided.info.key.addition"), requirerBundles);
        }
        return new BundleInfo(name, "/#", BundleInfoType.LINK, descr);
    }

    private static final class CapabilityFilter
    implements Predicate<BundleCapability> {
        private BundleWiring wiring;

        CapabilityFilter(BundleWiring wiring) {
            this.wiring = wiring;
        }

        @Override
        public boolean test(BundleCapability t) {
            return CapabilitiesPrinter.EXCLUDED_NAMESPACES_PREDICATE.test(t.getNamespace()) && (!STANDARD_NAMESPACES.contains(t.getNamespace()) || !this.wiring.getProvidedWires(t.getNamespace()).isEmpty());
        }
    }
}

