/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.servlet;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.http.jakartawrappers.HttpServletRequestWrapper;
import org.apache.felix.http.jakartawrappers.HttpServletResponseWrapper;
import org.apache.felix.http.jakartawrappers.ServletConfigWrapper;
import org.apache.felix.http.javaxwrappers.ServletExceptionUtil;
import org.apache.felix.webconsole.AbstractWebConsolePlugin;
import org.apache.felix.webconsole.servlet.AbstractServlet;
import org.osgi.framework.ServiceReference;

public class JakartaServletAdapter
extends AbstractWebConsolePlugin {
    private static final long serialVersionUID = 1L;
    private final String label;
    private final String title;
    private final AbstractServlet plugin;
    private final String[] cssReferences;

    public JakartaServletAdapter(AbstractServlet plugin, ServiceReference<Servlet> serviceReference) {
        this.label = (String)serviceReference.getProperty("felix.webconsole.label");
        this.title = (String)serviceReference.getProperty("felix.webconsole.title");
        this.plugin = plugin;
        this.cssReferences = this.toStringArray(serviceReference.getProperty("felix.webconsole.css"));
        this.activate(serviceReference.getBundle().getBundleContext());
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    protected String[] getCssReferences() {
        return this.cssReferences;
    }

    @Override
    protected void renderContent(javax.servlet.http.HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.plugin.renderContent((HttpServletRequest)HttpServletRequestWrapper.getWrapper((ServletRequest)req), (jakarta.servlet.http.HttpServletResponse)HttpServletResponseWrapper.getWrapper((ServletResponse)res));
        }
        catch (jakarta.servlet.ServletException s) {
            throw ServletExceptionUtil.getServletException((jakarta.servlet.ServletException)s);
        }
    }

    @Override
    protected Object getResourceProvider() {
        return this.plugin;
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            super.init(config);
            try {
                this.plugin.init((jakarta.servlet.ServletConfig)new ServletConfigWrapper(config));
            }
            catch (jakarta.servlet.ServletException s) {
                throw ServletExceptionUtil.getServletException((jakarta.servlet.ServletException)s);
            }
        }
        catch (ServletException se) {
            this.deactivate();
            throw se;
        }
    }

    public void service(javax.servlet.http.HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        CheckHttpServletResponse checkResponse = new CheckHttpServletResponse(resp);
        try {
            this.plugin.service((jakarta.servlet.ServletRequest)((HttpServletRequest)HttpServletRequestWrapper.getWrapper((ServletRequest)req)), (jakarta.servlet.ServletResponse)checkResponse);
        }
        catch (jakarta.servlet.ServletException s) {
            throw ServletExceptionUtil.getServletException((jakarta.servlet.ServletException)s);
        }
        if (!checkResponse.isDone()) {
            this.doGet(req, resp);
        }
    }

    public void destroy() {
        try {
            this.plugin.destroy();
            super.destroy();
        }
        finally {
            this.deactivate();
        }
    }

    private String[] toStringArray(Object value) {
        Collection<Object> cssListColl;
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value != null && (cssListColl = value.getClass().isArray() ? Arrays.asList((Object[])value) : (value instanceof Collection ? (Collection)value : null)) != null && !cssListColl.isEmpty()) {
            String[] entries = new String[cssListColl.size()];
            int i = 0;
            Iterator<Object> cli = cssListColl.iterator();
            while (cli.hasNext()) {
                entries[i] = String.valueOf(cli.next());
                ++i;
            }
            return entries;
        }
        return null;
    }

    private static final class CheckHttpServletResponse
    extends HttpServletResponseWrapper {
        private boolean done = false;

        public CheckHttpServletResponse(HttpServletResponse response) {
            super(response);
        }

        public boolean isDone() {
            return this.done;
        }

        public void reset() {
            this.done = false;
            super.reset();
        }

        public void sendError(int sc) throws IOException {
            this.done = true;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.done = true;
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.done = true;
            super.sendRedirect(location);
        }

        public void setStatus(int sc) {
            this.done = true;
            super.setStatus(sc);
        }

        public void setStatus(int sc, String sm) {
            this.done = true;
            super.setStatus(sc, sm);
        }

        public void setContentType(String type) {
            this.done = true;
            super.setContentType(type);
        }
    }
}

