/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.ds.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeInformation;
import org.osgi.service.metatype.MetaTypeService;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetatypeSupport {
    public boolean check(Object obj, Bundle providingBundle, String pid) {
        MetaTypeService mts = (MetaTypeService)obj;
        MetaTypeInformation mti = mts.getMetaTypeInformation(providingBundle);
        if (mti != null) {
            try {
                return mti.getObjectClassDefinition(pid, null) != null;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return false;
    }

    public Collection<String> getPasswordAttributeDefinitionIds(Object mts, Bundle bundle, String[] configurationPids) {
        MetaTypeService metaTypeService = (MetaTypeService)mts;
        MetaTypeInformation metaTypeInformation = metaTypeService.getMetaTypeInformation(bundle);
        if (metaTypeInformation == null) {
            return Collections.emptySet();
        }
        HashSet<String> allPasswordIds = new HashSet<String>();
        for (String configurationPid : configurationPids) {
            allPasswordIds.addAll(this.getPasswordIds(metaTypeInformation, configurationPid));
        }
        return allPasswordIds;
    }

    private Set<String> getPasswordIds(MetaTypeInformation metaTypeInformation, String configurationPid) {
        AttributeDefinition[] defs = null;
        try {
            ObjectClassDefinition ocd = metaTypeInformation.getObjectClassDefinition(configurationPid, null);
            defs = ocd.getAttributeDefinitions(-1);
        }
        catch (IllegalArgumentException ocd) {
            // empty catch block
        }
        HashSet<String> passwordsDefIds = new HashSet<String>();
        if (defs != null) {
            for (int i = 0; i < defs.length; ++i) {
                if (defs[i].getType() != 12) continue;
                passwordsDefIds.add(defs[i].getID());
            }
        }
        return passwordsDefIds;
    }
}

