/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.common;

import flex2.compiler.common.Configuration;
import flex2.compiler.common.ConfigurationPathResolver;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.config.ConfigurationInfo;
import flex2.compiler.config.ConfigurationValue;
import flex2.compiler.io.VirtualFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeSharedLibrarySettingsConfiguration {
    private Configuration configuration;
    protected ConfigurationPathResolver configResolver;
    private Set<VirtualFile> forceRsls;
    private HashMap<VirtualFile, String> applicationDomains;

    public RuntimeSharedLibrarySettingsConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setConfigPathResolver(ConfigurationPathResolver resolver) {
        this.configResolver = resolver;
    }

    public VirtualFile[] getForceRsls() {
        if (this.forceRsls == null) {
            return new VirtualFile[0];
        }
        return this.forceRsls.toArray(new VirtualFile[0]);
    }

    public Set<String> getForceRslsPaths() {
        if (this.forceRsls == null) {
            return Collections.emptySet();
        }
        HashSet<String> rslPaths = new HashSet<String>();
        for (VirtualFile file : this.forceRsls) {
            rslPaths.add(file.getName());
        }
        return rslPaths;
    }

    public void cfgForceRsls(ConfigurationValue cfgval, String[] args) throws ConfigurationException {
        if (this.configuration.getStaticLinkRsl()) {
            return;
        }
        if (this.forceRsls == null) {
            this.forceRsls = new HashSet<VirtualFile>();
        }
        for (String arg : args) {
            VirtualFile swcFile = ConfigurationPathResolver.getVirtualFile(arg, this.configResolver, cfgval);
            String swcPath = swcFile.getName();
            if (!this.doesSwcHaveRSLInfo(swcPath)) {
                throw new ConfigurationException.SwcDoesNotHaveRslData(swcPath, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            this.forceRsls.add(swcFile);
        }
    }

    public static ConfigurationInfo getForceRslsInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }
        };
    }

    public String getApplicationDomain(String swcPath) {
        if (this.applicationDomains == null || swcPath == null) {
            return ApplicationDomainTarget.DEFAULT.applicationDomainValue;
        }
        for (Map.Entry<VirtualFile, String> entry : this.applicationDomains.entrySet()) {
            VirtualFile swcFile = entry.getKey();
            if (!swcFile.getName().equals(swcPath)) continue;
            return entry.getValue();
        }
        return ApplicationDomainTarget.DEFAULT.applicationDomainValue;
    }

    public Map<VirtualFile, String> getApplicationDomains() {
        if (this.applicationDomains == null) {
            return Collections.emptyMap();
        }
        return this.applicationDomains;
    }

    public void cfgApplicationDomain(ConfigurationValue cfgval, String[] args) throws ConfigurationException {
        if (this.configuration.getStaticLinkRsl()) {
            return;
        }
        if (this.applicationDomains == null) {
            this.applicationDomains = new HashMap();
        }
        for (int i = 0; i < args.length; ++i) {
            String arg;
            VirtualFile swcFile;
            String swcPath;
            if (!this.doesSwcHaveRSLInfo(swcPath = (swcFile = ConfigurationPathResolver.getVirtualFile(arg = args[i++], this.configResolver, cfgval)).getName())) {
                throw new ConfigurationException.SwcDoesNotHaveRslData(swcPath, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            arg = args[i];
            if (!this.isValidApplicationDomainTarget(arg)) {
                throw new ConfigurationException.BadApplicationDomainValue(swcPath, arg, cfgval.getVar(), cfgval.getSource(), cfgval.getLine());
            }
            this.applicationDomains.put(swcFile, arg);
        }
    }

    public static ConfigurationInfo getApplicationDomainInfo() {
        return new ConfigurationInfo(-1, new String[]{"path-element", "application-domain-target"}){

            public boolean allowMultiple() {
                return true;
            }

            public boolean isAdvanced() {
                return true;
            }

            public String getArgName(int argnum) {
                String argName = null;
                argName = (argnum %= 2) == 0 ? "path-element" : "application-domain-target";
                return argName;
            }
        };
    }

    private boolean doesSwcHaveRSLInfo(String swcPath) {
        if (swcPath == null) {
            return false;
        }
        List<Configuration.RslPathInfo> rslInfoList = this.configuration.getRslPathInfo();
        for (Configuration.RslPathInfo rslInfo : rslInfoList) {
            if (!swcPath.equals(rslInfo.getSwcVirtualFile().getName())) continue;
            return true;
        }
        return false;
    }

    private boolean isValidApplicationDomainTarget(String arg) {
        for (ApplicationDomainTarget appDomain : ApplicationDomainTarget.values()) {
            if (!appDomain.applicationDomainValue.equals(arg)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ApplicationDomainTarget {
        DEFAULT("default"),
        CURRENT("current"),
        PARENT("parent"),
        TOP_LEVEL("top-level");

        private String applicationDomainValue;

        private ApplicationDomainTarget(String applicationDomainValue) {
            this.applicationDomainValue = applicationDomainValue;
        }

        public String getApplicationDomainValue() {
            return this.applicationDomainValue;
        }
    }
}

