/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.forks.batik.dom.svg;

import org.apache.flex.forks.batik.parser.AngleParser;
import org.apache.flex.forks.batik.parser.DefaultAngleHandler;
import org.apache.flex.forks.batik.parser.ParseException;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGAngle;

public class SVGOMAngle
implements SVGAngle {
    protected short unitType;
    protected float value;
    protected static final String[] UNITS = new String[]{"", "", "deg", "rad", "grad"};
    protected static double[][] K = new double[][]{{1.0, Math.PI / 180, 0.015707963267948967}, {57.29577951308232, 1.0, 63.66197723675813}, {0.9, 0.015707963267948967, 1.0}};

    public short getUnitType() {
        this.revalidate();
        return this.unitType;
    }

    public float getValue() {
        this.revalidate();
        return SVGOMAngle.toUnit(this.unitType, this.value, (short)2);
    }

    public void setValue(float value) throws DOMException {
        this.revalidate();
        this.unitType = (short)2;
        this.value = value;
        this.reset();
    }

    public float getValueInSpecifiedUnits() {
        this.revalidate();
        return this.value;
    }

    public void setValueInSpecifiedUnits(float value) throws DOMException {
        this.revalidate();
        this.value = value;
        this.reset();
    }

    public String getValueAsString() {
        this.revalidate();
        return Float.toString(this.value) + UNITS[this.unitType];
    }

    public void setValueAsString(String value) throws DOMException {
        this.parse(value);
        this.reset();
    }

    public void newValueSpecifiedUnits(short unit, float value) {
        this.unitType = unit;
        this.value = value;
        this.reset();
    }

    public void convertToSpecifiedUnits(short unit) {
        this.value = SVGOMAngle.toUnit(this.unitType, this.value, unit);
        this.unitType = unit;
    }

    protected void reset() {
    }

    protected void revalidate() {
    }

    protected void parse(String s) {
        try {
            AngleParser angleParser = new AngleParser();
            angleParser.setAngleHandler(new DefaultAngleHandler(){

                @Override
                public void angleValue(float v) throws ParseException {
                    SVGOMAngle.this.value = v;
                }

                @Override
                public void deg() throws ParseException {
                    SVGOMAngle.this.unitType = (short)2;
                }

                @Override
                public void rad() throws ParseException {
                    SVGOMAngle.this.unitType = (short)3;
                }

                @Override
                public void grad() throws ParseException {
                    SVGOMAngle.this.unitType = (short)4;
                }
            });
            this.unitType = 1;
            angleParser.parse(s);
        }
        catch (ParseException e) {
            this.unitType = 0;
            this.value = 0.0f;
        }
    }

    public static float toUnit(short fromUnit, float value, short toUnit) {
        if (fromUnit == 1) {
            fromUnit = (short)2;
        }
        if (toUnit == 1) {
            toUnit = (short)2;
        }
        return (float)(K[fromUnit - 2][toUnit - 2] * (double)value);
    }
}

