/*
 * Decompiled with CFR 0.152.
 */
package flex.tools.debugger.cli;

import flash.tools.debugger.PlayerDebugException;
import flash.tools.debugger.Session;
import flash.tools.debugger.Value;
import flash.tools.debugger.Variable;
import flash.tools.debugger.concrete.DValue;
import flash.tools.debugger.events.ExceptionFault;
import flash.tools.debugger.events.FaultEvent;
import flash.tools.debugger.expression.Context;
import flash.tools.debugger.expression.ExpressionEvaluatorException;
import flash.tools.debugger.expression.NoSuchVariableException;
import flash.tools.debugger.expression.PlayerFaultException;
import flex.tools.debugger.cli.ExpressionCache;
import flex.tools.debugger.cli.InternalProperty;
import flex.tools.debugger.cli.VariableFacade;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionContext
implements Context {
    ExpressionCache m_cache;
    Object m_current;
    boolean m_createIfMissing;
    Vector<String> m_namedPath;
    boolean m_nameLocked;
    String m_newline = System.getProperty("line.separator");
    int m_isolateId;

    public ExpressionContext(ExpressionCache cache) {
        this.m_cache = cache;
        this.m_current = null;
        this.m_createIfMissing = false;
        this.m_namedPath = new Vector();
        this.m_nameLocked = false;
        this.m_isolateId = 1;
    }

    public void setIsolateId(int id) {
        this.m_isolateId = id;
    }

    void setContext(Object o) {
        this.m_current = o;
    }

    void pushName(String name) {
        if (this.m_nameLocked || name.length() < 1) {
            return;
        }
        this.m_namedPath.add(name);
    }

    boolean setName(String name) {
        if (this.m_nameLocked) {
            return true;
        }
        this.m_namedPath.clear();
        this.pushName(name);
        return true;
    }

    void lockName() {
        this.m_nameLocked = true;
    }

    public String getName() {
        int size = this.m_namedPath.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            String s = this.m_namedPath.get(i);
            if (i > 0) {
                sb.append('.');
            }
            sb.append(s);
        }
        return sb.toString();
    }

    String getCurrentPackageName() {
        String s = null;
        try {
            Integer o = (Integer)this.m_cache.get("$listmodule");
            s = this.m_cache.getPackageName(o);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return s;
    }

    public void createPseudoVariables(boolean oui) {
        this.m_createIfMissing = oui;
    }

    public Context createContext(Object o) {
        ExpressionContext c = new ExpressionContext(this.m_cache);
        c.setContext(o);
        c.createPseudoVariables(this.m_createIfMissing);
        c.m_namedPath.addAll(this.m_namedPath);
        c.setIsolateId(this.m_isolateId);
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assign(Object o, Value v) throws NoSuchVariableException, PlayerFaultException {
        block8: {
            try {
                InternalProperty prop = this.resolveToInternalProperty(o);
                if (prop != null) {
                    this.assignInternal(prop, v);
                    break block8;
                }
                boolean wasCreateIfMissing = this.m_createIfMissing;
                this.createPseudoVariables(true);
                Variable var = null;
                try {
                    var = this.resolveToVariable(o);
                }
                finally {
                    this.createPseudoVariables(wasCreateIfMissing);
                }
                if (var == null) {
                    throw new NoSuchVariableException(var == null ? this.m_current : var.getName());
                }
                FaultEvent faultEvent = var.setValue(this.getSession(), v.getType(), v.getValueAsString());
                if (faultEvent != null) {
                    throw new PlayerFaultException(faultEvent);
                }
            }
            catch (PlayerDebugException pde) {
                throw new ExpressionEvaluatorException(pde);
            }
        }
    }

    public Object lookup(Object o) throws NoSuchVariableException, PlayerFaultException {
        Object result = null;
        try {
            result = this.resolveToInternalProperty(o);
            if (result == null && (result = this.resolveToVariable(o)) == null && (result = this.resolveToValue(o)) == null) {
                throw new NoSuchVariableException(o);
            }
            if (result != null && result instanceof VariableFacade) {
                ((VariableFacade)result).setPath(this.getName());
            }
            Value resultValue = null;
            if (result instanceof Variable) {
                resultValue = result instanceof VariableFacade && ((VariableFacade)result).getVariable() == null ? null : ((Variable)result).getValue();
            } else if (result instanceof Value) {
                resultValue = (Value)result;
            }
            if (resultValue != null && resultValue.isAttributeSet(262144)) {
                String value = resultValue.getValueAsString();
                throw new PlayerFaultException(new ExceptionFault(value, false, resultValue, resultValue.getIsolateId()));
            }
        }
        catch (PlayerDebugException pde) {
            result = Value.UNDEFINED;
        }
        return result;
    }

    public Object lookupMembers(Object o) throws NoSuchVariableException {
        String[] classHierarchy;
        Variable var = null;
        Value val = null;
        Variable[] mems = null;
        try {
            var = this.resolveToVariable(o);
            val = var != null ? var.getValue() : this.resolveToValue(o);
            mems = val.getMembers(this.getSession());
        }
        catch (NullPointerException npe) {
            throw new NoSuchVariableException(o);
        }
        catch (PlayerDebugException pde) {
            throw new NoSuchVariableException(o);
        }
        StringBuilder sb = new StringBuilder();
        if (var != null) {
            this.m_cache.appendVariable(sb, var, this.m_isolateId);
        } else {
            this.m_cache.appendVariableValue(sb, val, this.m_isolateId);
        }
        boolean attrs = this.m_cache.propertyEnabled("$displayattributes");
        if (attrs && var != null) {
            ExpressionCache.appendVariableAttributes(sb, var);
        }
        if ((classHierarchy = val.getClassHierarchy(false)) != null && this.getSession().getPreference("$hiervars") != 0) {
            for (int c = 0; c < classHierarchy.length; ++c) {
                String classname = classHierarchy[c];
                sb.append(this.m_newline + "(Members of " + classname + ")");
                for (int i = 0; i < mems.length; ++i) {
                    if (!classname.equals(mems[i].getDefiningClass())) continue;
                    sb.append(this.m_newline + " ");
                    this.m_cache.appendVariable(sb, mems[i], this.m_isolateId);
                    if (!attrs) continue;
                    ExpressionCache.appendVariableAttributes(sb, mems[i]);
                }
            }
        } else {
            for (int i = 0; i < mems.length; ++i) {
                sb.append(this.m_newline + " ");
                this.m_cache.appendVariable(sb, mems[i], this.m_isolateId);
                if (!attrs) continue;
                ExpressionCache.appendVariableAttributes(sb, mems[i]);
            }
        }
        return sb.toString();
    }

    private void assignInternal(InternalProperty var, Value v) throws NoSuchVariableException, NumberFormatException, PlayerDebugException {
        if (v.getType() != 0) {
            throw new NumberFormatException(v.getValueAsString());
        }
        long l = Long.parseLong(v.getValueAsString());
        this.m_cache.put(var.getName(), (int)l);
    }

    InternalProperty resolveToInternalProperty(Object o) {
        if (o instanceof String && ((String)o).charAt(0) == '$') {
            String key = (String)o;
            Object value = null;
            try {
                value = this.m_cache.get(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new InternalProperty(key, value);
        }
        return null;
    }

    Variable resolveToVariable(Object o) throws PlayerDebugException {
        Variable v = null;
        if (o instanceof Variable) {
            return (Variable)o;
        }
        String name = o.toString();
        long id = this.nameAsId(name);
        if (id == -1L) {
            id = this.determineContext(name);
            v = this.locateForNamed(id, name, true);
            if (v != null) {
                v = new VariableFacade(v, id, this.m_isolateId);
            } else if (v == null && this.m_createIfMissing && name.charAt(0) != '$') {
                v = new VariableFacade(id, name, this.m_isolateId);
            }
        }
        return v;
    }

    Value resolveToValue(Object o) throws PlayerDebugException {
        Value v = null;
        if (o instanceof Value) {
            return (Value)o;
        }
        if (o instanceof Variable) {
            return ((Variable)o).getValue();
        }
        if (o instanceof InternalProperty) {
            return DValue.forPrimitive(((InternalProperty)o).m_value, this.m_isolateId);
        }
        if (this.m_current == null) {
            String name = o.toString();
            long id = this.nameAsId(name);
            v = id != -1L ? this.getSession().getWorkerSession(this.m_isolateId).getValue((int)id) : (name.equals("undefined") ? DValue.forPrimitive(Value.UNDEFINED, this.m_isolateId) : this.getSession().getWorkerSession(this.m_isolateId).getGlobal(name));
        }
        return v;
    }

    long nameAsId(String name) {
        long id = -1L;
        try {
            if (name.charAt(0) == '#') {
                id = Long.parseLong(name.substring(1));
            }
        }
        catch (Exception e) {
            id = -1L;
        }
        return id;
    }

    Variable memberNamed(long id, String name) throws NoSuchVariableException, PlayerDebugException {
        Variable v = null;
        Value parent = this.getSession().getWorkerSession(this.m_isolateId).getValue(id);
        if (parent == null) {
            throw new NoSuchVariableException(name);
        }
        v = parent.getMemberNamed(this.getSession(), name);
        return v;
    }

    long determineContext(String name) throws PlayerDebugException {
        long id = -1L;
        if (this.m_current != null) {
            id = this.toValue().getId();
        } else if (name != null) {
            long baseId = -100L;
            int depth = (Integer)this.m_cache.get("$displayframenumber");
            Variable contextVar = null;
            Value contextVal = null;
            Value val = null;
            val = this.locateParentForNamed(baseId -= (long)depth, name, false);
            if (val != null || (contextVar = this.locateForNamed(baseId, "this", false)) != null && this.setName("this") && (val = this.locateParentForNamed(contextVar.getValue().getId(), name, true)) != null || this.setName("_root") && (val = this.locateParentForNamed(-4L, name, true)) != null || this.setName("_global") && (val = this.locateParentForNamed(-2L, name, true)) != null || (contextVal = this.locate(-2L, this.getCurrentPackageName(), false)) == null || !this.setName("_global." + this.getCurrentPackageName()) || (val = this.locateParentForNamed(contextVal.getId(), name, true)) != null) {
                // empty if block
            }
            if (val != null) {
                id = val.getId();
                this.pushName(name);
                this.lockName();
            }
        }
        return id;
    }

    Value locateParentForNamed(long id, String name, boolean traverseProto) throws PlayerDebugException {
        StringBuilder sb = new StringBuilder();
        Variable var = null;
        Value val = null;
        try {
            var = this.memberNamed(id, name);
            while (var == null && traverseProto) {
                Variable proto = this.memberNamed(id, "__proto__");
                sb.append("__proto__");
                if (proto == null) {
                    traverseProto = false;
                    continue;
                }
                id = proto.getValue().getId();
                var = this.memberNamed(id, name);
                if (var != null) continue;
                sb.append('.');
            }
        }
        catch (NoSuchVariableException noSuchVariableException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (var != null) {
            this.pushName(sb.toString());
            val = this.getSession().getWorkerSession(this.m_isolateId).getValue(id);
        }
        return val;
    }

    Variable locateForNamed(long id, String name, boolean traverseProto) throws PlayerDebugException {
        Variable var = null;
        Value v = this.locateParentForNamed(id, name, traverseProto);
        if (v != null) {
            try {
                var = this.memberNamed(v.getId(), name);
            }
            catch (NoSuchVariableException nse) {
                v = null;
            }
        }
        return var;
    }

    Value locate(long startingId, String dottedName, boolean traverseProto) throws PlayerDebugException {
        if (dottedName == null) {
            return null;
        }
        StringTokenizer names = new StringTokenizer(dottedName, ".");
        Value val = this.getSession().getWorkerSession(this.m_isolateId).getValue(startingId);
        while (names.hasMoreTokens() && val != null) {
            val = this.locateForNamed(val.getId(), names.nextToken(), traverseProto).getValue();
        }
        return val;
    }

    public Value toValue(Object o) {
        if (o instanceof Value) {
            return (Value)o;
        }
        if (o instanceof Variable) {
            return ((Variable)o).getValue();
        }
        if (o instanceof InternalProperty) {
            return DValue.forPrimitive(((InternalProperty)o).m_value, this.m_isolateId);
        }
        return DValue.forPrimitive(o, this.m_isolateId);
    }

    public Value toValue() {
        return this.toValue(this.m_current);
    }

    public Session getSession() {
        return this.m_cache.getSession();
    }

    public int getIsolateId() {
        return this.m_isolateId;
    }
}

