/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.dom.richtext;

import com.adobe.fxg.FXGException;
import com.adobe.fxg.dom.FXGNode;
import com.adobe.internal.fxg.dom.DOMParserHelper;
import com.adobe.internal.fxg.dom.richtext.AbstractRichTextNode;
import com.adobe.internal.fxg.dom.richtext.TextHelper;
import com.adobe.internal.fxg.dom.types.AlignmentBaseline;
import com.adobe.internal.fxg.dom.types.BaselineShift;
import com.adobe.internal.fxg.dom.types.BreakOpportunity;
import com.adobe.internal.fxg.dom.types.ColorWithEnum;
import com.adobe.internal.fxg.dom.types.DigitCase;
import com.adobe.internal.fxg.dom.types.DigitWidth;
import com.adobe.internal.fxg.dom.types.DominantBaseline;
import com.adobe.internal.fxg.dom.types.FontStyle;
import com.adobe.internal.fxg.dom.types.FontWeight;
import com.adobe.internal.fxg.dom.types.Kerning;
import com.adobe.internal.fxg.dom.types.LigatureLevel;
import com.adobe.internal.fxg.dom.types.NumberInherit;
import com.adobe.internal.fxg.dom.types.TextDecoration;
import com.adobe.internal.fxg.dom.types.TextRotation;
import com.adobe.internal.fxg.dom.types.TypographicCase;
import com.adobe.internal.fxg.dom.types.WhiteSpaceCollapse;

public abstract class AbstractRichTextLeafNode
extends AbstractRichTextNode {
    protected static final double FONTSIZE_MIN_INCLUSIVE = 1.0;
    protected static final double FONTSIZE_MAX_INCLUSIVE = 720.0;
    protected static final double BASELINESHIFT_MIN_INCLUSIVE = -1000.0;
    protected static final double BASELINESHIFT_MAX_INCLUSIVE = 1000.0;
    protected static final double LINEHEIGHT_PERCENT_MIN_INCLUSIVE = -1000.0;
    protected static final double LINEHEIGHT_PERCENT_MAX_INCLUSIVE = 1000.0;
    protected static final double LINEHEIGHT_PIXEL_MIN_INCLUSIVE = -720.0;
    protected static final double LINEHEIGHT_PIXEL_MAX_INCLUSIVE = 720.0;
    protected static final double TRACKING_MIN_INCLUSIVE = -1000.0;
    protected static final double TRACKING_MAX_INCLUSIVE = 1000.0;
    public String fontFamily = "Arial";
    public double fontSize = 12.0;
    public FontStyle fontStyle = FontStyle.NORMAL;
    public FontWeight fontWeight = FontWeight.NORMAL;
    public Kerning kerning = Kerning.AUTO;
    public double lineHeight = 120.0;
    public TextDecoration textDecoration = TextDecoration.NONE;
    public boolean lineThrough = false;
    public int color = -16777216;
    public double textAlpha = 1.0;
    public WhiteSpaceCollapse whiteSpaceCollapse = WhiteSpaceCollapse.COLLAPSE;
    public NumberInherit backgroundAlpha = NumberInherit.newInstance(1.0);
    public ColorWithEnum backgroundColor = ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
    public BaselineShift baselineShift = BaselineShift.newInstance(0.0);
    public BreakOpportunity breakOpportunity = BreakOpportunity.AUTO;
    public DigitCase digitCase = DigitCase.DEFAULT;
    public DigitWidth digitWidth = DigitWidth.DEFAULT;
    public DominantBaseline dominantBaseline = DominantBaseline.AUTO;
    public AlignmentBaseline alignmentBaseline = AlignmentBaseline.USEDOMINANTBASELINE;
    public LigatureLevel ligatureLevel = LigatureLevel.COMMON;
    public String locale = "en";
    public TypographicCase typographicCase = TypographicCase.DEFAULT;
    public double trackingLeft = 0.0;
    public double trackingRight = 0.0;
    public TextRotation textRotation = TextRotation.AUTO;

    public void setAttribute(String name, String value) {
        if ("fontFamily".equals(name)) {
            this.fontFamily = value;
        } else if ("fontSize".equals(name)) {
            this.fontSize = DOMParserHelper.parseDouble(this, value, name, 1.0, 720.0, this.fontSize);
        } else if ("fontStyle".equals(name)) {
            this.fontStyle = TextHelper.getFontStyle(this, value);
        } else if ("fontWeight".equals(name)) {
            this.fontWeight = TextHelper.getFontWeight(this, value);
        } else if ("kerning".equals(name)) {
            this.kerning = TextHelper.getKerning(this, value);
        } else if ("lineHeight".equals(name)) {
            this.lineHeight = DOMParserHelper.parseNumberPercentWithSeparateRange(this, value, name, -720.0, 720.0, -1000.0, 1000.0, this.lineHeight);
        } else if ("textDecoration".equals(name)) {
            this.textDecoration = TextHelper.getTextDecoration(this, value);
        } else if ("lineThrough".equals(name)) {
            this.lineThrough = DOMParserHelper.parseBoolean(this, value, name);
        } else if ("color".equals(name)) {
            this.color = DOMParserHelper.parseRGB(this, value, name);
        } else if ("textAlpha".equals(name)) {
            this.textAlpha = DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, this.textAlpha);
        } else if ("whiteSpaceCollapse".equals(name)) {
            this.whiteSpaceCollapse = TextHelper.getWhiteSpaceCollapse(this, value);
        } else if ("backgroundAlpha".equals(name)) {
            this.backgroundAlpha = this.getAlphaInherit(this, name, value, 0.0, 1.0, this.backgroundAlpha.getNumberInheritAsDbl(), "UnknownBackgroundAlpha");
        } else if ("backgroundColor".equals(name)) {
            this.backgroundColor = this.getColorWithEnum(this, name, value);
        } else if ("baselineShift".equals(name)) {
            this.baselineShift = this.getBaselineShift(this, name, value, -1000.0, 1000.0, this.baselineShift.getBaselineShiftAsDbl());
        } else if ("breakOpportunity".equals(name)) {
            this.breakOpportunity = TextHelper.getBreakOpportunity(this, value);
        } else if ("digitCase".equals(name)) {
            this.digitCase = TextHelper.getDigitCase(this, value);
        } else if ("digitWidth".equals(name)) {
            this.digitWidth = TextHelper.getDigitWidth(this, value);
        } else if ("dominantBaseline".equals(name)) {
            this.dominantBaseline = TextHelper.getDominantBaseline(this, value);
        } else if ("alignmentBaseline".equals(name)) {
            this.alignmentBaseline = TextHelper.getAlignmentBaseline(this, value);
        } else if ("ligatureLevel".equals(name)) {
            this.ligatureLevel = TextHelper.getLigatureLevel(this, value);
        } else if ("locale".equals(name)) {
            this.locale = value;
        } else if ("typographicCase".equals(name)) {
            this.typographicCase = TextHelper.getTypographicCase(this, value);
        } else if ("trackingLeft".equals(name)) {
            this.trackingLeft = DOMParserHelper.parseNumberPercent(this, value, name, -1000.0, 1000.0, this.trackingLeft);
        } else if ("trackingRight".equals(name)) {
            this.trackingRight = DOMParserHelper.parseNumberPercent(this, value, name, -1000.0, 1000.0, this.trackingRight);
        } else if ("textRotation".equals(name)) {
            this.textRotation = TextHelper.getTextRotation(this, value);
        } else {
            super.setAttribute(name, value);
            return;
        }
        this.rememberAttribute(name, value);
    }

    private BaselineShift getBaselineShift(FXGNode node, String name, String value, double min, double max, double defaultValue) {
        try {
            return BaselineShift.newInstance(DOMParserHelper.parseNumberPercent(this, value, name, min, max, defaultValue));
        }
        catch (FXGException e) {
            if ("superscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUPERSCRIPT);
            }
            if ("subscript".equals(value)) {
                return BaselineShift.newInstance(BaselineShift.BaselineShiftAsEnum.SUBSCRIPT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), "UnknownBaselineShift", value);
        }
    }

    private NumberInherit getAlphaInherit(FXGNode node, String name, String value, double min, double max, double defaultValue, String errorCode) {
        try {
            return NumberInherit.newInstance(DOMParserHelper.parseDouble(this, value, name, 0.0, 1.0, defaultValue));
        }
        catch (FXGException e) {
            if ("inherit".equals(value)) {
                return NumberInherit.newInstance(NumberInherit.NumberInheritAsEnum.INHERIT);
            }
            throw new FXGException(node.getStartLine(), node.getStartColumn(), errorCode, value);
        }
    }

    private ColorWithEnum getColorWithEnum(FXGNode node, String attribute, String value) {
        if ("transparent".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.TRANSPARENT);
        }
        if ("inherit".equals(value)) {
            return ColorWithEnum.newInstance(ColorWithEnum.ColorEnum.INHERIT);
        }
        return ColorWithEnum.newInstance(DOMParserHelper.parseRGB(this, value, attribute));
    }
}

