/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.fxg.swf;

import com.adobe.fxg.FXGVersion;
import com.adobe.internal.fxg.dom.BitmapGraphicNode;
import com.adobe.internal.fxg.dom.FillNode;
import com.adobe.internal.fxg.dom.fills.BitmapFillNode;
import com.adobe.internal.fxg.dom.types.FillMode;
import com.adobe.internal.fxg.swf.ShapeHelper;
import com.adobe.internal.fxg.swf.TypeHelper;
import flash.graphics.images.ImageUtil;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineBitsLossless;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineTag;
import flash.swf.types.FillStyle;
import flash.swf.types.Matrix;
import flash.swf.types.Rect;
import flash.swf.types.ShapeRecord;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.util.FileUtils;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ImageHelper {
    public static final String MIME_GIF = "image/gif";
    public static final String MIME_JPEG = "image/jpeg";
    public static final String MIME_JPG = "image/jpg";
    public static final String MIME_PNG = "image/png";

    public static DefineShape createShapeForImage(DefineBits tag, BitmapGraphicNode node) {
        double width = node.width;
        double height = node.height;
        boolean repeat = node.repeat;
        FillMode fillMode = node.fillMode;
        FXGVersion fileVersion = node.getFileVersion();
        if (Double.isNaN(width)) {
            width = tag.width;
        }
        if (Double.isNaN(height)) {
            height = tag.height;
        }
        Matrix matrix = new Matrix();
        matrix.scaleX = 0x140000;
        matrix.scaleY = 0x140000;
        matrix.hasScale = true;
        FillStyle fs = null;
        if (fileVersion.equalTo(FXGVersion.v1_0)) {
            fs = repeat ? new FillStyle(64, matrix, (DefineTag)tag) : new FillStyle(65, matrix, (DefineTag)tag);
        } else if (fillMode.equals((Object)FillMode.REPEAT)) {
            fs = new FillStyle(64, matrix, (DefineTag)tag);
        } else if (fillMode.equals((Object)FillMode.CLIP)) {
            fs = new FillStyle(65, matrix, (DefineTag)tag);
        } else if (fillMode.equals((Object)FillMode.SCALE)) {
            matrix.scaleX = (int)StrictMath.rint(width * 20.0 * 65536.0 / (double)tag.width);
            matrix.scaleY = (int)StrictMath.rint(height * 20.0 * 65536.0 / (double)tag.height);
            fs = new FillStyle(65, matrix, (DefineTag)tag);
        }
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.fillstyles = new ArrayList(1);
        sws.fillstyles.add(fs);
        List<ShapeRecord> shapeRecords = ShapeHelper.rectangle(width, height);
        ShapeHelper.setStyles(shapeRecords, 0, 1, 0);
        sws.shapeRecords = shapeRecords;
        DefineShape defineShape = new DefineShape(83);
        defineShape.edgeBounds = defineShape.bounds = TypeHelper.rect(width, height);
        defineShape.shapeWithStyle = sws;
        return defineShape;
    }

    public static boolean bitmapImageNeedsClipping(DefineBits imageTag, BitmapGraphicNode node) {
        return (node.getFileVersion().equalTo(FXGVersion.v1_0) && !node.repeat || node.fillMode.equals((Object)FillMode.CLIP)) && ((double)imageTag.width < node.width || (double)imageTag.height < node.height);
    }

    public static boolean bitmapFillModeIsRepeat(BitmapFillNode node) {
        return node.getFileVersion().equalTo(FXGVersion.v1_0) && node.repeat || node.fillMode.equals((Object)FillMode.REPEAT);
    }

    public static boolean isBitmapFillWithClip(FillNode fill) {
        if (fill == null) {
            return false;
        }
        if (fill instanceof BitmapFillNode) {
            BitmapFillNode bFill = (BitmapFillNode)fill;
            if (ImageHelper.bitmapFillModeIsRepeat(bFill)) {
                return false;
            }
            if (bFill.getFileVersion().equalTo(FXGVersion.v2_0) && bFill.fillMode == FillMode.SCALE) {
                return !Double.isNaN(bFill.scaleX) || !Double.isNaN(bFill.scaleY) || !Double.isNaN(bFill.x) || !Double.isNaN(bFill.y) || !Double.isNaN(bFill.rotation) && !(Math.abs(bFill.rotation) < 1.0E-5) || bFill.matrix != null;
            }
            return true;
        }
        return false;
    }

    public static DefineBits createDefineBits(InputStream in, String mimeType) throws IOException {
        byte[] bytes = FileUtils.toByteArray((InputStream)in);
        Image image = ImageUtil.getImage((byte[])bytes);
        if (mimeType == null) {
            throw new IOException("Unsupported MIME type");
        }
        PixelGrabber pixelGrabber = null;
        try {
            pixelGrabber = ImageUtil.getPixelGrabber((Image)image, null);
        }
        catch (Exception e) {
            throw new IOException("Error reading image");
        }
        int width = pixelGrabber.getWidth();
        int height = pixelGrabber.getHeight();
        if (MIME_JPG.equals(mimeType) || MIME_JPEG.equals(mimeType)) {
            DefineBits imageTag = new DefineBits(21);
            imageTag.data = bytes;
            imageTag.width = width;
            imageTag.height = height;
            return imageTag;
        }
        if (MIME_PNG.equals(mimeType) || MIME_GIF.equals(mimeType)) {
            int[] pixels = (int[])pixelGrabber.getPixels();
            DefineBitsLossless imageTag = ImageHelper.createDefineBitsLossless(pixels, width, height);
            return imageTag;
        }
        throw new IOException("Unsupported MIME type: " + mimeType);
    }

    public static DefineBitsLossless createDefineBitsLossless(int[] pixels, int width, int height) {
        DefineBitsLossless defineBitsLossless = new DefineBitsLossless(36);
        defineBitsLossless.format = 5;
        defineBitsLossless.width = width;
        defineBitsLossless.height = height;
        defineBitsLossless.data = new byte[pixels.length * 4];
        for (int i = 0; i < pixels.length; ++i) {
            int offset = i * 4;
            int alpha = pixels[i] >> 24 & 0xFF;
            defineBitsLossless.data[offset] = (byte)alpha;
            if (defineBitsLossless.data[offset] == 0) continue;
            int red = pixels[i] >> 16 & 0xFF;
            defineBitsLossless.data[offset + 1] = (byte)(red * alpha / 255);
            int green = pixels[i] >> 8 & 0xFF;
            defineBitsLossless.data[offset + 2] = (byte)(green * alpha / 255);
            int blue = pixels[i] & 0xFF;
            defineBitsLossless.data[offset + 3] = (byte)(blue * alpha / 255);
        }
        return defineBitsLossless;
    }

    public static DefineShape create9SlicedShape(DefineBits bitmap, Rect r, double width, double height) {
        if (Double.isNaN(width)) {
            width = bitmap.width;
        }
        if (Double.isNaN(height)) {
            height = bitmap.height;
        }
        int slt = r.xMin;
        int srt = r.xMax;
        int stt = r.yMin;
        int sbt = r.yMax;
        ArrayList<Object> shapeRecords = new ArrayList<Object>(50);
        ShapeWithStyle sws = new ShapeWithStyle();
        sws.fillstyles = new ArrayList(9);
        sws.shapeRecords = shapeRecords;
        Matrix matrix = new Matrix();
        matrix.scaleX = 0x140000;
        matrix.scaleY = 0x140000;
        matrix.hasScale = true;
        for (int i = 0; i < 9; ++i) {
            FillStyle fs = new FillStyle(66, matrix, (DefineTag)bitmap);
            sws.fillstyles.add(fs);
        }
        int dxa = slt;
        int dxb = srt - slt;
        int dxc = bitmap.width * 20 - srt;
        int dya = stt;
        int dyb = sbt - stt;
        int dyc = bitmap.height * 20 - sbt;
        shapeRecords.add(new StyleChangeRecord(0, dya, 0, 0, 1));
        shapeRecords.add(new StraightEdgeRecord(0, -dya));
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        shapeRecords.add(new StyleChangeRecord(0, 0, 2));
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        shapeRecords.add(new StyleChangeRecord(0, 0, 3));
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        shapeRecords.add(new StyleChangeRecord(0, 0, 6));
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        shapeRecords.add(new StyleChangeRecord(0, 0, 9));
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        shapeRecords.add(new StraightEdgeRecord(-dxc, 0));
        shapeRecords.add(new StyleChangeRecord(0, 0, 8));
        shapeRecords.add(new StraightEdgeRecord(-dxb, 0));
        shapeRecords.add(new StyleChangeRecord(0, 0, 7));
        shapeRecords.add(new StraightEdgeRecord(-dxa, 0));
        shapeRecords.add(new StraightEdgeRecord(0, -dyc));
        shapeRecords.add(new StyleChangeRecord(0, 0, 4));
        shapeRecords.add(new StraightEdgeRecord(0, -dyb));
        shapeRecords.add(new StyleChangeRecord(dxa, 0, 0, 2, 1));
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        shapeRecords.add(new StyleChangeRecord(0, 5, 4));
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        shapeRecords.add(new StyleChangeRecord(0, 8, 7));
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        shapeRecords.add(new StyleChangeRecord(dxa + dxb, 0, 0, 3, 2));
        shapeRecords.add(new StraightEdgeRecord(0, dya));
        shapeRecords.add(new StyleChangeRecord(0, 6, 5));
        shapeRecords.add(new StraightEdgeRecord(0, dyb));
        shapeRecords.add(new StyleChangeRecord(0, 9, 8));
        shapeRecords.add(new StraightEdgeRecord(0, dyc));
        shapeRecords.add(new StyleChangeRecord(0, dya, 0, 1, 4));
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        shapeRecords.add(new StyleChangeRecord(0, 2, 5));
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        shapeRecords.add(new StyleChangeRecord(0, 3, 6));
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        shapeRecords.add(new StyleChangeRecord(0, dya + dyb, 0, 4, 7));
        shapeRecords.add(new StraightEdgeRecord(dxa, 0));
        shapeRecords.add(new StyleChangeRecord(0, 5, 8));
        shapeRecords.add(new StraightEdgeRecord(dxb, 0));
        shapeRecords.add(new StyleChangeRecord(0, 6, 9));
        shapeRecords.add(new StraightEdgeRecord(dxc, 0));
        DefineShape shape = new DefineShape(83);
        shape.edgeBounds = shape.bounds = TypeHelper.rect(width, height);
        shape.shapeWithStyle = sws;
        return shape;
    }

    public static String guessMimeType(String path) {
        if (path != null) {
            if ((path = path.toLowerCase()).endsWith(".png")) {
                return MIME_PNG;
            }
            if (path.endsWith(".gif")) {
                return MIME_GIF;
            }
            if (path.endsWith(".jpg")) {
                return MIME_JPG;
            }
            if (path.endsWith(".jpeg")) {
                return MIME_JPEG;
            }
        }
        return null;
    }
}

