/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.definitions;

import org.apache.flex.abc.ABCConstants;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IConstantDefinition;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.VariableDefinition;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.scopes.ASScope;
import org.apache.flex.compiler.internal.scopes.ScopeView;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.as.IExpressionNode;

public class ConstantDefinition
extends VariableDefinition
implements IConstantDefinition {
    public ConstantDefinition(String name) {
        super(name);
    }

    public ConstantDefinition(String name, Object value) {
        super(name, value);
    }

    @Override
    public void buildInnerString(StringBuilder sb) {
        sb.append(this.getNamespaceReferenceAsString());
        sb.append(' ');
        sb.append("const");
        sb.append(' ');
        sb.append(this.getBaseName());
        String type = this.getTypeAsDisplayString();
        if (!type.isEmpty()) {
            sb.append(':');
            sb.append(type);
        }
    }

    @Override
    public Object resolveValue(ICompilerProject project) {
        if (this.declaredInControlFlow()) {
            return null;
        }
        if (this.initValue != null) {
            return this.resolveUndefined(project, this.initValue);
        }
        return ((CompilerProject)project).getCacheForScope(this.getContainingASScope()).getConstantValue(this);
    }

    public Object resolveValueFrom(ICompilerProject project, NodeBase fromNode) {
        IExpressionNode initNode;
        if (this.declaredInControlFlow()) {
            return null;
        }
        if (this.initValue != null) {
            return this.resolveUndefined(project, this.initValue);
        }
        if (fromNode != null && fromNode.getFileScope() == this.getFileScope() && (fromNode.getAbsoluteStart() <= this.getAbsoluteStart() ? !this.isReferenceToStaticFromInstanceScope(fromNode) : (initNode = this.getInitExpression()) != null && (initNode.getAbsoluteStart() == fromNode.getAbsoluteStart() || initNode.contains(fromNode.getAbsoluteStart())))) {
            return null;
        }
        return this.resolveValue(project);
    }

    public Object resolveValueImpl(ICompilerProject project) {
        if (this.declaredInControlFlow()) {
            return null;
        }
        Object value = super.resolveInitialValue(project);
        value = this.resolveUndefined(project, value);
        return value;
    }

    private Object resolveUndefined(ICompilerProject project, Object value) {
        if (value == ABCConstants.UNDEFINED_VALUE && this.resolveType(project) != ClassDefinition.getAnyTypeClassDefinition()) {
            value = null;
        }
        return value;
    }

    private boolean isReferenceToStaticFromInstanceScope(NodeBase fromNode) {
        if (this.isStatic()) {
            IClassDefinition containingClass = (IClassDefinition)this.getAncestorOfType(IClassDefinition.class);
            for (ASScope fromScope = fromNode.getASScope(); fromScope != null; fromScope = fromScope.getContainingScope()) {
                if (!(fromScope instanceof ScopeView)) continue;
                return ((ScopeView)fromScope).isInstanceScope() && fromScope.getDefinition() == containingClass;
            }
        }
        return false;
    }
}

