/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.ollama4j.models.response.ModelMeta;
import io.github.ollama4j.utils.Utils;
import java.time.OffsetDateTime;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Model {
    private String name;
    private String model;
    @JsonProperty(value="modified_at")
    private OffsetDateTime modifiedAt;
    @JsonProperty(value="expires_at")
    private OffsetDateTime expiresAt;
    private String digest;
    private long size;
    @JsonProperty(value="details")
    private ModelMeta modelMeta;

    public String getModelName() {
        return this.name.split(":")[0];
    }

    public String getModelVersion() {
        return this.name.split(":")[1];
    }

    public String toString() {
        try {
            return Utils.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Generated
    public Model() {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public OffsetDateTime getModifiedAt() {
        return this.modifiedAt;
    }

    @Generated
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public String getDigest() {
        return this.digest;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public ModelMeta getModelMeta() {
        return this.modelMeta;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @JsonProperty(value="modified_at")
    @Generated
    public void setModifiedAt(OffsetDateTime modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    @JsonProperty(value="expires_at")
    @Generated
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setDigest(String digest) {
        this.digest = digest;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @JsonProperty(value="details")
    @Generated
    public void setModelMeta(ModelMeta modelMeta) {
        this.modelMeta = modelMeta;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Model)) {
            return false;
        }
        Model other = (Model)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        OffsetDateTime this$modifiedAt = this.getModifiedAt();
        OffsetDateTime other$modifiedAt = other.getModifiedAt();
        if (this$modifiedAt == null ? other$modifiedAt != null : !((Object)this$modifiedAt).equals(other$modifiedAt)) {
            return false;
        }
        OffsetDateTime this$expiresAt = this.getExpiresAt();
        OffsetDateTime other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        String this$digest = this.getDigest();
        String other$digest = other.getDigest();
        if (this$digest == null ? other$digest != null : !this$digest.equals(other$digest)) {
            return false;
        }
        ModelMeta this$modelMeta = this.getModelMeta();
        ModelMeta other$modelMeta = other.getModelMeta();
        return !(this$modelMeta == null ? other$modelMeta != null : !((Object)this$modelMeta).equals(other$modelMeta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Model;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        OffsetDateTime $modifiedAt = this.getModifiedAt();
        result = result * 59 + ($modifiedAt == null ? 43 : ((Object)$modifiedAt).hashCode());
        OffsetDateTime $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        String $digest = this.getDigest();
        result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
        ModelMeta $modelMeta = this.getModelMeta();
        result = result * 59 + ($modelMeta == null ? 43 : ((Object)$modelMeta).hashCode());
        return result;
    }
}

