/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.data;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.utils.FileUtils;
import org.apache.flink.table.store.file.utils.RecordReader;

public class AppendOnlyReader
implements RecordReader<RowData> {
    private final BulkFormat.Reader<RowData> reader;

    public AppendOnlyReader(Path path, BulkFormat<RowData, FileSourceSplit> readerFactory) throws IOException {
        this.reader = FileUtils.createFormatReader(readerFactory, path);
    }

    @Override
    @Nullable
    public RecordReader.RecordIterator<RowData> readBatch() throws IOException {
        BulkFormat.RecordIterator iterator = this.reader.readBatch();
        return iterator == null ? null : new AppendOnlyRecordIterator(iterator);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private static class AppendOnlyRecordIterator
    implements RecordReader.RecordIterator<RowData> {
        private final BulkFormat.RecordIterator<RowData> iterator;

        private AppendOnlyRecordIterator(BulkFormat.RecordIterator<RowData> iterator) {
            this.iterator = iterator;
        }

        @Override
        public RowData next() throws IOException {
            RecordAndPosition result = this.iterator.next();
            return result == null ? null : (RowData)result.getRecord();
        }

        @Override
        public void releaseBatch() {
            this.iterator.releaseBatch();
        }
    }
}

