/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.primitive;

import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveCharObjectInspector;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.typeinfo.BaseCharUtils;
import org.apache.flink.table.store.shaded.org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;

public class JavaHiveCharObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableHiveCharObjectInspector {
    public JavaHiveCharObjectInspector() {
    }

    public JavaHiveCharObjectInspector(CharTypeInfo typeInfo) {
        super(typeInfo);
    }

    @Override
    public HiveChar getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveChar value = o instanceof String ? new HiveChar((String)o, this.getMaxLength()) : (HiveChar)o;
        if (BaseCharUtils.doesPrimitiveMatchTypeParams(value, (CharTypeInfo)this.typeInfo)) {
            return value;
        }
        return this.getPrimitiveWithParams(value);
    }

    @Override
    public HiveCharWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveChar var = o instanceof String ? new HiveChar((String)o, this.getMaxLength()) : (HiveChar)o;
        return this.getWritableWithParams(var);
    }

    private HiveChar getPrimitiveWithParams(HiveChar val) {
        HiveChar hc = new HiveChar(val, this.getMaxLength());
        return hc;
    }

    private HiveCharWritable getWritableWithParams(HiveChar val) {
        HiveCharWritable hcw = new HiveCharWritable();
        hcw.set(val, this.getMaxLength());
        return hcw;
    }

    @Override
    public Object set(Object o, HiveChar value) {
        if (BaseCharUtils.doesPrimitiveMatchTypeParams(value, (CharTypeInfo)this.typeInfo)) {
            return value;
        }
        return new HiveChar(value, this.getMaxLength());
    }

    @Override
    public Object set(Object o, String value) {
        return new HiveChar(value, this.getMaxLength());
    }

    @Override
    public Object create(HiveChar value) {
        HiveChar hc = new HiveChar(value, this.getMaxLength());
        return hc;
    }

    public int getMaxLength() {
        CharTypeInfo ti = (CharTypeInfo)this.typeInfo;
        return ti.getLength();
    }
}

