/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.connector.file.table.MetastoreCommitPolicy;
import org.apache.flink.connector.file.table.SuccessFileCommitPolicy;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.ValidationException;

@Experimental
public interface PartitionCommitPolicy {
    public static final String METASTORE = "metastore";
    public static final String SUCCESS_FILE = "success-file";
    public static final String CUSTOM = "custom";

    public void commit(Context var1) throws Exception;

    public static List<PartitionCommitPolicy> createPolicyChain(ClassLoader cl, String policyKind, String customClass, String successFileName, Supplier<FileSystem> fsSupplier) {
        if (policyKind == null) {
            return Collections.emptyList();
        }
        String[] policyStrings = policyKind.split(",");
        return Arrays.stream(policyStrings).map(name -> {
            switch (name.toLowerCase()) {
                case "metastore": {
                    return new MetastoreCommitPolicy();
                }
                case "success-file": {
                    return new SuccessFileCommitPolicy(successFileName, (FileSystem)fsSupplier.get());
                }
                case "custom": {
                    try {
                        return (PartitionCommitPolicy)cl.loadClass(customClass).newInstance();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new RuntimeException("Can not create new instance for custom class from " + customClass, e);
                    }
                }
            }
            throw new UnsupportedOperationException("Unsupported policy: " + name);
        }).collect(Collectors.toList());
    }

    public static void validatePolicyChain(boolean isEmptyMetastore, String policyKind) {
        if (policyKind != null) {
            String[] policyStrings;
            for (String policy : policyStrings = policyKind.split(",")) {
                if (!isEmptyMetastore || !METASTORE.equalsIgnoreCase(policy)) continue;
                throw new ValidationException("Can not configure a 'metastore' partition commit policy for a file system table. You can only configure 'metastore' partition commit policy for a hive table.");
            }
        }
    }

    public static interface Context {
        public String catalogName();

        public String databaseName();

        public String tableName();

        public List<String> partitionKeys();

        public List<String> partitionValues();

        public Path partitionPath();

        default public LinkedHashMap<String, String> partitionSpec() {
            LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
            for (int i = 0; i < this.partitionKeys().size(); ++i) {
                res.put(this.partitionKeys().get(i), this.partitionValues().get(i));
            }
            return res;
        }
    }
}

