/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.logical;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class MultisetType
extends LogicalType {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT = "MULTISET<%s>";
    private static final Set<String> INPUT_OUTPUT_CONVERSION = MultisetType.conversionSet(Map.class.getName(), MapData.class.getName());
    private static final Class<?> DEFAULT_CONVERSION = Map.class;
    private final LogicalType elementType;

    public MultisetType(boolean isNullable, LogicalType elementType) {
        super(isNullable, LogicalTypeRoot.MULTISET);
        this.elementType = Preconditions.checkNotNull(elementType, "Element type must not be null.");
    }

    public MultisetType(LogicalType elementType) {
        this(true, elementType);
    }

    public LogicalType getElementType() {
        return this.elementType;
    }

    @Override
    public LogicalType copy(boolean isNullable) {
        return new MultisetType(isNullable, this.elementType.copy());
    }

    @Override
    public String asSummaryString() {
        return this.withNullability(FORMAT, this.elementType.asSummaryString());
    }

    @Override
    public String asSerializableString() {
        return this.withNullability(FORMAT, this.elementType.asSerializableString());
    }

    @Override
    public boolean supportsInputConversion(Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            return true;
        }
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public boolean supportsOutputConversion(Class<?> clazz) {
        return INPUT_OUTPUT_CONVERSION.contains(clazz.getName());
    }

    @Override
    public Class<?> getDefaultConversion() {
        return DEFAULT_CONVERSION;
    }

    @Override
    public List<LogicalType> getChildren() {
        return Collections.singletonList(this.elementType);
    }

    @Override
    public <R> R accept(LogicalTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MultisetType that = (MultisetType)o;
        return this.elementType.equals(that.elementType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementType);
    }
}

