/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.InflaterInputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.java.typeutils.runtime.KryoRegistrationSerializerConfigSnapshot;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.FlinkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class InstantiationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(InstantiationUtil.class);
    private static final Set<String> scalaSerializerClassnames = new HashSet<String>();
    private static final Set<String> scalaTypes;

    private static boolean isAnonymousClass(Class clazz) {
        String name = clazz.getName();
        if (name.contains("$anon$") || name.contains("$anonfun") || name.contains("$macro$")) {
            return true;
        }
        try {
            return clazz.isAnonymousClass();
        }
        catch (InternalError e) {
            return false;
        }
    }

    private static boolean isOldAvroSerializer(String name, long serialVersionUID) {
        return serialVersionUID == 1L && "org.apache.flink.formats.avro.typeutils.AvroSerializer".equals(name);
    }

    public static <T> T instantiate(String className, Class<T> targetType, ClassLoader classLoader) throws FlinkException {
        Class<T> clazz;
        try {
            clazz = Class.forName(className, false, classLoader).asSubclass(targetType);
        }
        catch (ClassNotFoundException e) {
            throw new FlinkException(String.format("Could not instantiate class '%s' of type '%s'. Please make sure that this class is on your class path.", className, targetType.getName()), e);
        }
        return InstantiationUtil.instantiate(clazz);
    }

    public static <T> T instantiate(Class<T> clazz, Class<? super T> castTo) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (castTo != null && !castTo.isAssignableFrom(clazz)) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not a subclass of '" + castTo.getName() + "' as is required.");
        }
        return InstantiationUtil.instantiate(clazz);
    }

    public static <T> T instantiate(Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException iex) {
            InstantiationUtil.checkForInstantiation(clazz);
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' due to an unspecified exception: " + iex.getMessage(), iex);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            throw new RuntimeException("Could not instantiate type '" + clazz.getName() + "' Most likely the constructor (or a member variable initialization) threw an exception" + (message == null ? "." : ": " + message), t);
        }
    }

    public static boolean hasPublicNullaryConstructor(Class<?> clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isProperClass(Class<?> clazz) {
        int mods = clazz.getModifiers();
        return !Modifier.isAbstract(mods) && !Modifier.isInterface(mods) && !Modifier.isNative(mods);
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return clazz.getEnclosingClass() != null && (clazz.getDeclaringClass() == null || !Modifier.isStatic(clazz.getModifiers()));
    }

    public static void checkForInstantiation(Class<?> clazz) {
        String errorMessage = InstantiationUtil.checkForInstantiationError(clazz);
        if (errorMessage != null) {
            throw new RuntimeException("The class '" + clazz.getName() + "' is not instantiable: " + errorMessage);
        }
    }

    public static String checkForInstantiationError(Class<?> clazz) {
        if (!InstantiationUtil.isPublic(clazz)) {
            return "The class is not public.";
        }
        if (clazz.isArray()) {
            return "The class is an array. An array cannot be simply instantiated, as with a parameterless constructor.";
        }
        if (!InstantiationUtil.isProperClass(clazz)) {
            return "The class is not a proper class. It is either abstract, an interface, or a primitive type.";
        }
        if (InstantiationUtil.isNonStaticInnerClass(clazz)) {
            return "The class is an inner class, but not statically accessible.";
        }
        if (!InstantiationUtil.hasPublicNullaryConstructor(clazz)) {
            return "The class has no (implicit) public nullary constructor, i.e. a constructor without arguments.";
        }
        return null;
    }

    public static <T> T readObjectFromConfig(Configuration config, String key, ClassLoader cl) throws IOException, ClassNotFoundException {
        byte[] bytes = config.getBytes(key, null);
        if (bytes == null) {
            return null;
        }
        return InstantiationUtil.deserializeObject(bytes, cl);
    }

    public static void writeObjectToConfig(Object o, Configuration config, String key) throws IOException {
        byte[] bytes = InstantiationUtil.serializeObject(o);
        config.setBytes(key, bytes);
    }

    public static <T> byte[] serializeToByteArray(TypeSerializer<T> serializer, T record) throws IOException {
        if (record == null) {
            throw new NullPointerException("Record to serialize to byte array must not be null.");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(64);
        DataOutputViewStreamWrapper outputViewWrapper = new DataOutputViewStreamWrapper(bos);
        serializer.serialize(record, outputViewWrapper);
        return bos.toByteArray();
    }

    public static <T> T deserializeFromByteArray(TypeSerializer<T> serializer, byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException("Byte array to deserialize from must not be null.");
        }
        DataInputViewStreamWrapper inputViewWrapper = new DataInputViewStreamWrapper(new ByteArrayInputStream(buf));
        return serializer.deserialize(inputViewWrapper);
    }

    public static <T> T deserializeFromByteArray(TypeSerializer<T> serializer, T reuse, byte[] buf) throws IOException {
        if (buf == null) {
            throw new NullPointerException("Byte array to deserialize from must not be null.");
        }
        DataInputViewStreamWrapper inputViewWrapper = new DataInputViewStreamWrapper(new ByteArrayInputStream(buf));
        return serializer.deserialize(reuse, inputViewWrapper);
    }

    public static <T> T deserializeObject(byte[] bytes, ClassLoader cl) throws IOException, ClassNotFoundException {
        return InstantiationUtil.deserializeObject(bytes, cl, false);
    }

    public static <T> T deserializeObject(InputStream in, ClassLoader cl) throws IOException, ClassNotFoundException {
        return InstantiationUtil.deserializeObject(in, cl, false);
    }

    public static <T> T deserializeObject(byte[] bytes, ClassLoader cl, boolean isFailureTolerant) throws IOException, ClassNotFoundException {
        return InstantiationUtil.deserializeObject(new ByteArrayInputStream(bytes), cl, isFailureTolerant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserializeObject(InputStream in, ClassLoader cl, boolean isFailureTolerant) throws IOException, ClassNotFoundException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoaderObjectInputStream oois = isFailureTolerant ? new FailureTolerantObjectInputStream(in, cl) : new ClassLoaderObjectInputStream(in, cl);
            Thread.currentThread().setContextClassLoader(cl);
            Object object = oois.readObject();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public static <T> T decompressAndDeserializeObject(byte[] bytes, ClassLoader cl) throws IOException, ClassNotFoundException {
        return InstantiationUtil.deserializeObject(new InflaterInputStream(new ByteArrayInputStream(bytes)), cl, false);
    }

    /*
     * Exception decompiling
     */
    public static byte[] serializeObject(Object o) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void serializeObject(OutputStream out, Object o) throws IOException {
        ObjectOutputStream oos = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
        oos.writeObject(o);
    }

    /*
     * Exception decompiling
     */
    public static byte[] serializeObjectAndCompress(Object o) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isSerializable(Object o) {
        try {
            InstantiationUtil.serializeObject(o);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static <T extends Serializable> T clone(T obj) throws IOException, ClassNotFoundException {
        if (obj == null) {
            return null;
        }
        return InstantiationUtil.clone(obj, obj.getClass().getClassLoader());
    }

    public static <T extends Serializable> T clone(T obj, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (obj == null) {
            return null;
        }
        byte[] serializedObject = InstantiationUtil.serializeObject(obj);
        return (T)((Serializable)InstantiationUtil.deserializeObject(serializedObject, classLoader));
    }

    public static <T extends IOReadableWritable> T createCopyWritable(T original) throws IOException {
        if (original == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(baos);){
            original.write(out);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        try (DataInputViewStreamWrapper in = new DataInputViewStreamWrapper(bais);){
            IOReadableWritable copy = (IOReadableWritable)InstantiationUtil.instantiate(original.getClass());
            copy.read(in);
            IOReadableWritable iOReadableWritable = copy;
            return (T)iOReadableWritable;
        }
    }

    public static <T> Class<T> resolveClassByName(DataInputView in, ClassLoader cl) throws IOException {
        return InstantiationUtil.resolveClassByName(in, cl, Object.class);
    }

    public static <T> Class<T> resolveClassByName(DataInputView in, ClassLoader cl, Class<? super T> supertype) throws IOException {
        Class<?> rawClazz;
        String className = in.readUTF();
        try {
            rawClazz = Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Could not find class '" + className + "' in classpath.", e);
        }
        if (!supertype.isAssignableFrom(rawClazz)) {
            throw new IOException("The class " + className + " is not a subclass of " + supertype.getName());
        }
        Class<?> clazz = rawClazz;
        return clazz;
    }

    private InstantiationUtil() {
        throw new RuntimeException();
    }

    static {
        scalaSerializerClassnames.add("org.apache.flink.api.scala.typeutils.TraversableSerializer");
        scalaSerializerClassnames.add("org.apache.flink.api.scala.typeutils.CaseClassSerializer");
        scalaSerializerClassnames.add("org.apache.flink.api.scala.typeutils.EitherSerializer");
        scalaSerializerClassnames.add("org.apache.flink.api.scala.typeutils.EnumValueSerializer");
        scalaSerializerClassnames.add("org.apache.flink.api.scala.typeutils.OptionSerializer");
        scalaSerializerClassnames.add("org.apache.flink.api.scala.typeutils.TrySerializer");
        scalaSerializerClassnames.add("org.apache.flink.api.scala.typeutils.UnitSerializer");
        scalaTypes = new HashSet<String>();
        scalaTypes.add("scala.Tuple1");
        scalaTypes.add("scala.Tuple2");
        scalaTypes.add("scala.Tuple3");
        scalaTypes.add("scala.Tuple4");
        scalaTypes.add("scala.Tuple5");
        scalaTypes.add("scala.Tuple6");
        scalaTypes.add("scala.Tuple7");
        scalaTypes.add("scala.Tuple8");
        scalaTypes.add("scala.Tuple9");
        scalaTypes.add("scala.Tuple10");
        scalaTypes.add("scala.Tuple11");
        scalaTypes.add("scala.Tuple12");
        scalaTypes.add("scala.Tuple13");
        scalaTypes.add("scala.Tuple14");
        scalaTypes.add("scala.Tuple15");
        scalaTypes.add("scala.Tuple16");
        scalaTypes.add("scala.Tuple17");
        scalaTypes.add("scala.Tuple18");
        scalaTypes.add("scala.Tuple19");
        scalaTypes.add("scala.Tuple20");
        scalaTypes.add("scala.Tuple21");
        scalaTypes.add("scala.Tuple22");
        scalaTypes.add("scala.Tuple1$mcJ$sp");
        scalaTypes.add("scala.Tuple1$mcI$sp");
        scalaTypes.add("scala.Tuple1$mcD$sp");
        scalaTypes.add("scala.Tuple2$mcJJ$sp");
        scalaTypes.add("scala.Tuple2$mcJI$sp");
        scalaTypes.add("scala.Tuple2$mcJD$sp");
        scalaTypes.add("scala.Tuple2$mcIJ$sp");
        scalaTypes.add("scala.Tuple2$mcII$sp");
        scalaTypes.add("scala.Tuple2$mcID$sp");
        scalaTypes.add("scala.Tuple2$mcDJ$sp");
        scalaTypes.add("scala.Tuple2$mcDI$sp");
        scalaTypes.add("scala.Tuple2$mcDD$sp");
        scalaTypes.add("scala.Enumeration$ValueSet");
    }

    private static enum MigrationUtil {
        GENERIC_DATA_ARRAY_SERIALIZER("org.apache.avro.generic.GenericData$Array", ObjectStreamClass.lookup(KryoRegistrationSerializerConfigSnapshot.DummyRegisteredClass.class)),
        HASH_MAP_SERIALIZER("org.apache.flink.runtime.state.HashMapSerializer", ObjectStreamClass.lookup(MapSerializer.class));

        private static final Map<String, ObjectStreamClass> EQUIVALENCE_MAP;
        private final String oldSerializerName;
        private final ObjectStreamClass newSerializerStreamClass;

        private MigrationUtil(String oldSerializerName, ObjectStreamClass newSerializerStreamClass) {
            this.oldSerializerName = oldSerializerName;
            this.newSerializerStreamClass = newSerializerStreamClass;
        }

        private static Map<String, ObjectStreamClass> initMap() {
            HashMap<String, ObjectStreamClass> init = new HashMap<String, ObjectStreamClass>(4);
            for (MigrationUtil m : MigrationUtil.values()) {
                init.put(m.oldSerializerName, m.newSerializerStreamClass);
            }
            return init;
        }

        private static ObjectStreamClass getEquivalentSerializer(String classDescriptorName) {
            return EQUIVALENCE_MAP.get(classDescriptorName);
        }

        static {
            EQUIVALENCE_MAP = Collections.unmodifiableMap(MigrationUtil.initMap());
        }
    }

    public static class FailureTolerantObjectInputStream
    extends ClassLoaderObjectInputStream {
        public FailureTolerantObjectInputStream(InputStream in, ClassLoader cl) throws IOException {
            super(in, cl);
        }

        @Override
        protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass localClassDescriptor;
            ObjectStreamClass streamClassDescriptor;
            block3: {
                streamClassDescriptor = super.readClassDescriptor();
                try {
                    Class.forName(streamClassDescriptor.getName(), false, this.classLoader);
                }
                catch (ClassNotFoundException e) {
                    ObjectStreamClass equivalentSerializer = MigrationUtil.getEquivalentSerializer(streamClassDescriptor.getName());
                    if (equivalentSerializer == null) break block3;
                    return equivalentSerializer;
                }
            }
            Class<?> localClass = this.resolveClass(streamClassDescriptor);
            String name = localClass.getName();
            if ((scalaSerializerClassnames.contains(name) || scalaTypes.contains(name) || InstantiationUtil.isAnonymousClass(localClass) || InstantiationUtil.isOldAvroSerializer(name, streamClassDescriptor.getSerialVersionUID())) && (localClassDescriptor = ObjectStreamClass.lookup(localClass)) != null && localClassDescriptor.getSerialVersionUID() != streamClassDescriptor.getSerialVersionUID()) {
                LOG.warn("Ignoring serialVersionUID mismatch for class {}; was {}, now {}.", new Object[]{streamClassDescriptor.getName(), streamClassDescriptor.getSerialVersionUID(), localClassDescriptor.getSerialVersionUID()});
                streamClassDescriptor = localClassDescriptor;
            }
            return streamClassDescriptor;
        }
    }

    public static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        protected final ClassLoader classLoader;
        private static final HashMap<String, Class<?>> primitiveClasses = new HashMap(9);

        public ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.classLoader != null) {
                String name = desc.getName();
                try {
                    return Class.forName(name, false, this.classLoader);
                }
                catch (ClassNotFoundException ex) {
                    Class<?> cl = primitiveClasses.get(name);
                    if (cl != null) {
                        return cl;
                    }
                    throw ex;
                }
            }
            return super.resolveClass(desc);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            if (this.classLoader != null) {
                ClassLoader nonPublicLoader = null;
                boolean hasNonPublicInterface = false;
                Class[] classObjs = new Class[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> cl = Class.forName(interfaces[i], false, this.classLoader);
                    if ((cl.getModifiers() & 1) == 0) {
                        if (hasNonPublicInterface) {
                            if (nonPublicLoader != cl.getClassLoader()) {
                                throw new IllegalAccessError("conflicting non-public interface class loaders");
                            }
                        } else {
                            nonPublicLoader = cl.getClassLoader();
                            hasNonPublicInterface = true;
                        }
                    }
                    classObjs[i] = cl;
                }
                try {
                    return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : this.classLoader, classObjs);
                }
                catch (IllegalArgumentException e) {
                    throw new ClassNotFoundException(null, e);
                }
            }
            return super.resolveProxyClass(interfaces);
        }

        static {
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("void", Void.TYPE);
        }
    }
}

