/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.metrics.View;

public class ViewUpdater {
    private final Set<View> toAdd = new HashSet<View>();
    private final Set<View> toRemove = new HashSet<View>();
    private final Object lock = new Object();

    public ViewUpdater(ScheduledExecutorService executor) {
        executor.scheduleWithFixedDelay(new ViewUpdaterTask(this.lock, this.toAdd, this.toRemove), 5L, 5L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedView(View view) {
        Object object = this.lock;
        synchronized (object) {
            this.toAdd.add(view);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedView(View view) {
        Object object = this.lock;
        synchronized (object) {
            this.toRemove.add(view);
        }
    }

    private static class ViewUpdaterTask
    extends TimerTask {
        private final Object lock;
        private final Set<View> views;
        private final Set<View> toAdd;
        private final Set<View> toRemove;

        private ViewUpdaterTask(Object lock, Set<View> toAdd, Set<View> toRemove) {
            this.lock = lock;
            this.views = new HashSet<View>();
            this.toAdd = toAdd;
            this.toRemove = toRemove;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (View toUpdate : this.views) {
                toUpdate.update();
            }
            Object object = this.lock;
            synchronized (object) {
                this.views.addAll(this.toAdd);
                this.toAdd.clear();
                this.views.removeAll(this.toRemove);
                this.toRemove.clear();
            }
        }
    }
}

