/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.utils;

import java.util.Arrays;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.types.RowKind;

public class ProjectedRowData
implements RowData {
    private final int[] indexMapping;
    private RowData row;

    private ProjectedRowData(int[] indexMapping) {
        this.indexMapping = indexMapping;
    }

    public ProjectedRowData replaceRow(RowData row) {
        this.row = row;
        return this;
    }

    @Override
    public int getArity() {
        return this.indexMapping.length;
    }

    @Override
    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    @Override
    public boolean isNullAt(int pos) {
        if (this.indexMapping[pos] < 0) {
            return true;
        }
        return this.row.isNullAt(this.indexMapping[pos]);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.row.getBoolean(this.indexMapping[pos]);
    }

    @Override
    public byte getByte(int pos) {
        return this.row.getByte(this.indexMapping[pos]);
    }

    @Override
    public short getShort(int pos) {
        return this.row.getShort(this.indexMapping[pos]);
    }

    @Override
    public int getInt(int pos) {
        return this.row.getInt(this.indexMapping[pos]);
    }

    @Override
    public long getLong(int pos) {
        return this.row.getLong(this.indexMapping[pos]);
    }

    @Override
    public float getFloat(int pos) {
        return this.row.getFloat(this.indexMapping[pos]);
    }

    @Override
    public double getDouble(int pos) {
        return this.row.getDouble(this.indexMapping[pos]);
    }

    @Override
    public StringData getString(int pos) {
        return this.row.getString(this.indexMapping[pos]);
    }

    @Override
    public DecimalData getDecimal(int pos, int precision, int scale) {
        return this.row.getDecimal(this.indexMapping[pos], precision, scale);
    }

    @Override
    public TimestampData getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(this.indexMapping[pos], precision);
    }

    @Override
    public <T> RawValueData<T> getRawValue(int pos) {
        return this.row.getRawValue(this.indexMapping[pos]);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.row.getBinary(this.indexMapping[pos]);
    }

    @Override
    public ArrayData getArray(int pos) {
        return this.row.getArray(this.indexMapping[pos]);
    }

    @Override
    public MapData getMap(int pos) {
        return this.row.getMap(this.indexMapping[pos]);
    }

    @Override
    public RowData getRow(int pos, int numFields) {
        return this.row.getRow(this.indexMapping[pos], numFields);
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Projected row data cannot be compared");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Projected row data cannot be hashed");
    }

    public String toString() {
        return this.row.getRowKind().shortString() + "{indexMapping=" + Arrays.toString(this.indexMapping) + ", mutableRow=" + this.row + '}';
    }

    public static ProjectedRowData from(int[][] projection) throws IllegalArgumentException {
        return new ProjectedRowData(Arrays.stream(projection).mapToInt(arr -> {
            if (((int[])arr).length != 1) {
                throw new IllegalArgumentException("ProjectedRowData doesn't support nested projections");
            }
            return arr[0];
        }).toArray());
    }

    public static ProjectedRowData from(int[] projection) {
        return new ProjectedRowData(projection);
    }

    public static ProjectedRowData from(Projection projection) {
        return new ProjectedRowData(projection.toTopLevelIndexes());
    }
}

