/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions.util;

import java.io.PrintStream;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;

@Internal
public class PrintSinkOutputWriter<IN>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean STD_OUT = false;
    private static final boolean STD_ERR = true;
    private final boolean target;
    private transient PrintStream stream;
    private final String sinkIdentifier;
    private transient String completedPrefix;

    public PrintSinkOutputWriter() {
        this("", false);
    }

    public PrintSinkOutputWriter(boolean stdErr) {
        this("", stdErr);
    }

    public PrintSinkOutputWriter(String sinkIdentifier, boolean stdErr) {
        this.target = stdErr;
        this.sinkIdentifier = sinkIdentifier == null ? "" : sinkIdentifier;
    }

    public void open(int subtaskIndex, int numParallelSubtasks) {
        this.stream = !this.target ? System.out : System.err;
        this.completedPrefix = this.sinkIdentifier;
        if (numParallelSubtasks > 1) {
            if (!this.completedPrefix.isEmpty()) {
                this.completedPrefix = this.completedPrefix + ":";
            }
            this.completedPrefix = this.completedPrefix + (subtaskIndex + 1);
        }
        if (!this.completedPrefix.isEmpty()) {
            this.completedPrefix = this.completedPrefix + "> ";
        }
    }

    public void write(IN record) {
        this.stream.println(this.completedPrefix + record.toString());
    }

    public String toString() {
        return "Print to " + (!this.target ? "System.out" : "System.err");
    }
}

