/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.management.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.rmi.registry.RegistryImpl;

class JMXServer {
    private static final Logger LOG = LoggerFactory.getLogger(JMXServer.class);
    private final AtomicReference<Remote> rmiServerReference = new AtomicReference();
    private Registry rmiRegistry;
    private JMXConnectorServer connector;
    private int port;

    JMXServer() {
    }

    void start(int port) throws IOException {
        if (this.rmiRegistry != null && this.connector != null) {
            LOG.debug("JMXServer is already running.");
            return;
        }
        this.internalStart(port);
        this.port = port;
    }

    void stop() throws IOException {
        this.rmiServerReference.set(null);
        if (this.connector != null) {
            try {
                this.connector.stop();
            }
            finally {
                this.connector = null;
            }
        }
        if (this.rmiRegistry != null) {
            try {
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            catch (NoSuchObjectException e) {
                throw new IOException("Could not un-export our RMI registry", e);
            }
            finally {
                this.rmiRegistry = null;
            }
        }
    }

    int getPort() {
        return this.port;
    }

    private void internalStart(int port) throws IOException {
        JMXServiceURL url;
        this.rmiServerReference.set(null);
        this.rmiRegistry = new JmxRegistry(port, "jmxrmi", this.rmiServerReference);
        String serviceUrl = "service:jmx:rmi://localhost:" + port + "/jndi/rmi://localhost:" + port + "/jmxrmi";
        try {
            url = new JMXServiceURL(serviceUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed service url created " + serviceUrl, e);
        }
        RMIJRMPServerImpl rmiServer = new RMIJRMPServerImpl(port, null, null, null);
        this.connector = new RMIConnectorServer(url, null, rmiServer, ManagementFactory.getPlatformMBeanServer());
        this.connector.start();
        this.rmiServerReference.set(rmiServer.toStub());
    }

    private static class JmxRegistry
    extends RegistryImpl {
        private final String lookupName;
        private final AtomicReference<Remote> remoteServerStub;

        JmxRegistry(int port, String lookupName, AtomicReference<Remote> remoteServerStub) throws RemoteException {
            super(port);
            this.lookupName = lookupName;
            this.remoteServerStub = remoteServerStub;
        }

        @Override
        public Remote lookup(String s) throws NotBoundException {
            Remote remote;
            if (this.lookupName.equals(s) && (remote = this.remoteServerStub.get()) != null) {
                return remote;
            }
            throw new NotBoundException("Not bound.");
        }

        @Override
        public void bind(String s, Remote remote) {
        }

        @Override
        public void unbind(String s) {
        }

        @Override
        public void rebind(String s, Remote remote) {
        }

        @Override
        public String[] list() {
            return new String[]{this.lookupName};
        }
    }
}

