/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.runtime.util.KeyGroupedIterator;
import org.apache.flink.util.MutableObjectIterator;
import org.apache.flink.util.TraversableOnceException;

public final class NonReusingKeyGroupedIterator<E>
implements KeyGroupedIterator<E> {
    private final MutableObjectIterator<E> iterator;
    private final TypeComparator<E> comparator;
    private ValuesIterator valuesIterator;
    private E lastKeyRecord;
    private E lookahead;
    private boolean done;

    public NonReusingKeyGroupedIterator(MutableObjectIterator<E> iterator, TypeComparator<E> comparator) {
        if (iterator == null || comparator == null) {
            throw new NullPointerException();
        }
        this.iterator = iterator;
        this.comparator = comparator;
    }

    @Override
    public boolean nextKey() throws IOException {
        if (this.lookahead != null) {
            this.comparator.setReference(this.lookahead);
            this.valuesIterator.next = this.lookahead;
            this.lastKeyRecord = this.lookahead;
            this.lookahead = null;
            this.valuesIterator.iteratorAvailable = true;
            return true;
        }
        if (this.done) {
            return false;
        }
        if (this.valuesIterator != null) {
            E next;
            while ((next = this.iterator.next()) != null) {
                if (this.comparator.equalToReference(next)) continue;
                this.comparator.setReference(next);
                this.valuesIterator.next = next;
                this.lastKeyRecord = next;
                this.valuesIterator.iteratorAvailable = true;
                return true;
            }
            this.valuesIterator.next = null;
            this.valuesIterator = null;
            this.lastKeyRecord = null;
            this.done = true;
            return false;
        }
        E first = this.iterator.next();
        if (first != null) {
            this.comparator.setReference(first);
            this.valuesIterator = new ValuesIterator(first);
            this.lastKeyRecord = first;
            return true;
        }
        this.done = true;
        return false;
    }

    private E advanceToNext() {
        try {
            E next = this.iterator.next();
            if (next != null) {
                if (this.comparator.equalToReference(next)) {
                    return next;
                }
                this.lookahead = next;
                return null;
            }
            this.done = true;
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while reading the next record.", e);
        }
    }

    @Override
    public E getCurrent() {
        return this.lastKeyRecord;
    }

    public TypeComparator<E> getComparatorWithCurrentReference() {
        return this.comparator;
    }

    public ValuesIterator getValues() {
        return this.valuesIterator;
    }

    public final class ValuesIterator
    implements Iterator<E>,
    Iterable<E> {
        private E next;
        private boolean iteratorAvailable = true;

        private ValuesIterator(E first) {
            this.next = first;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next != null) {
                Object current = this.next;
                this.next = NonReusingKeyGroupedIterator.this.advanceToNext();
                return current;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.iteratorAvailable) {
                this.iteratorAvailable = false;
                return this;
            }
            throw new TraversableOnceException();
        }
    }
}

