/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.streaming.runtime.io.DataInputStatus;
import org.apache.flink.util.Preconditions;

@Internal
public class MultipleInputSelectionHandler {
    public static final int MAX_SUPPORTED_INPUT_COUNT = 63;
    @Nullable
    private final InputSelectable inputSelectable;
    private long selectedInputsMask = InputSelection.ALL.getInputMask();
    private final long allSelectedMask;
    private long availableInputsMask;
    private long notFinishedInputsMask;
    private long dataFinishedButNotPartition;
    private boolean drainOnEndOfData = true;
    private OperatingMode operatingMode;

    public MultipleInputSelectionHandler(@Nullable InputSelectable inputSelectable, int inputCount) {
        MultipleInputSelectionHandler.checkSupportedInputCount(inputCount);
        this.inputSelectable = inputSelectable;
        this.availableInputsMask = this.allSelectedMask = (1L << inputCount) - 1L;
        this.notFinishedInputsMask = this.allSelectedMask;
        this.dataFinishedButNotPartition = 0L;
        this.operatingMode = inputSelectable != null ? OperatingMode.INPUT_SELECTABLE_PRESENT_NO_DATA_INPUTS_FINISHED : OperatingMode.NO_INPUT_SELECTABLE;
    }

    public static void checkSupportedInputCount(int inputCount) {
        Preconditions.checkArgument(inputCount <= 63, "Only up to %s inputs are supported at once, while encountered %s", 63, inputCount);
    }

    public DataInputStatus updateStatusAndSelection(DataInputStatus inputStatus, int inputIndex) throws IOException {
        switch (inputStatus) {
            case MORE_AVAILABLE: {
                this.nextSelection();
                Preconditions.checkState(this.checkBitMask(this.availableInputsMask, inputIndex));
                return DataInputStatus.MORE_AVAILABLE;
            }
            case NOTHING_AVAILABLE: {
                this.availableInputsMask = this.unsetBitMask(this.availableInputsMask, inputIndex);
                break;
            }
            case STOPPED: {
                this.drainOnEndOfData = false;
            }
            case END_OF_DATA: {
                this.dataFinishedButNotPartition = this.setBitMask(this.dataFinishedButNotPartition, inputIndex);
                this.updateModeOnEndOfData();
                break;
            }
            case END_OF_INPUT: {
                this.dataFinishedButNotPartition = this.unsetBitMask(this.dataFinishedButNotPartition, inputIndex);
                this.notFinishedInputsMask = this.unsetBitMask(this.notFinishedInputsMask, inputIndex);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported inputStatus = " + (Object)((Object)inputStatus));
            }
        }
        this.nextSelection();
        return this.calculateOverallStatus(inputStatus);
    }

    private void updateModeOnEndOfData() {
        boolean allDataInputsFinished;
        boolean bl = allDataInputsFinished = ((this.dataFinishedButNotPartition | this.notFinishedInputsMask ^ 0xFFFFFFFFFFFFFFFFL) & this.allSelectedMask) == this.allSelectedMask;
        if (allDataInputsFinished) {
            this.operatingMode = OperatingMode.ALL_DATA_INPUTS_FINISHED;
        } else if (this.operatingMode == OperatingMode.INPUT_SELECTABLE_PRESENT_NO_DATA_INPUTS_FINISHED) {
            this.operatingMode = OperatingMode.INPUT_SELECTABLE_PRESENT_SOME_DATA_INPUTS_FINISHED;
        }
    }

    private DataInputStatus calculateOverallStatus(DataInputStatus updatedStatus) throws IOException {
        if (this.areAllInputsFinished()) {
            return DataInputStatus.END_OF_INPUT;
        }
        if (updatedStatus == DataInputStatus.END_OF_DATA && this.operatingMode == OperatingMode.ALL_DATA_INPUTS_FINISHED) {
            return this.drainOnEndOfData ? DataInputStatus.END_OF_DATA : DataInputStatus.STOPPED;
        }
        if (this.isAnyInputAvailable()) {
            return DataInputStatus.MORE_AVAILABLE;
        }
        long selectedNotFinishedInputMask = this.selectedInputsMask & this.notFinishedInputsMask;
        if (selectedNotFinishedInputMask == 0L) {
            throw new IOException("Can not make a progress: all selected inputs are already finished");
        }
        return DataInputStatus.NOTHING_AVAILABLE;
    }

    void nextSelection() {
        switch (this.operatingMode) {
            case NO_INPUT_SELECTABLE: 
            case ALL_DATA_INPUTS_FINISHED: {
                this.selectedInputsMask = InputSelection.ALL.getInputMask();
                break;
            }
            case INPUT_SELECTABLE_PRESENT_NO_DATA_INPUTS_FINISHED: {
                this.selectedInputsMask = this.inputSelectable.nextSelection().getInputMask();
                break;
            }
            case INPUT_SELECTABLE_PRESENT_SOME_DATA_INPUTS_FINISHED: {
                this.selectedInputsMask = (this.inputSelectable.nextSelection().getInputMask() | this.dataFinishedButNotPartition) & this.allSelectedMask;
            }
        }
    }

    int selectNextInputIndex(int lastReadInputIndex) {
        return InputSelection.fairSelectNextIndex(this.selectedInputsMask, this.availableInputsMask & this.notFinishedInputsMask, lastReadInputIndex);
    }

    boolean shouldSetAvailableForAnotherInput() {
        return (this.selectedInputsMask & this.allSelectedMask & (this.availableInputsMask ^ 0xFFFFFFFFFFFFFFFFL)) != 0L;
    }

    void setAvailableInput(int inputIndex) {
        this.availableInputsMask = this.setBitMask(this.availableInputsMask, inputIndex);
    }

    void setUnavailableInput(int inputIndex) {
        this.availableInputsMask = this.unsetBitMask(this.availableInputsMask, inputIndex);
    }

    boolean isAnyInputAvailable() {
        return (this.selectedInputsMask & this.availableInputsMask & this.notFinishedInputsMask) != 0L;
    }

    boolean isInputSelected(int inputIndex) {
        return this.checkBitMask(this.selectedInputsMask, inputIndex);
    }

    public boolean isInputFinished(int inputIndex) {
        return !this.checkBitMask(this.notFinishedInputsMask, inputIndex);
    }

    public boolean areAllInputsFinished() {
        return this.notFinishedInputsMask == 0L;
    }

    public boolean areAllDataInputsFinished() {
        return this.operatingMode == OperatingMode.ALL_DATA_INPUTS_FINISHED;
    }

    long setBitMask(long mask, int inputIndex) {
        return mask | 1L << inputIndex;
    }

    long unsetBitMask(long mask, int inputIndex) {
        return mask & (1L << inputIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    boolean checkBitMask(long mask, int inputIndex) {
        return (mask & 1L << inputIndex) != 0L;
    }

    private static enum OperatingMode {
        NO_INPUT_SELECTABLE,
        INPUT_SELECTABLE_PRESENT_NO_DATA_INPUTS_FINISHED,
        INPUT_SELECTABLE_PRESENT_SOME_DATA_INPUTS_FINISHED,
        ALL_DATA_INPUTS_FINISHED;

    }
}

