/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.stats;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.stats.FieldStatsArraySerializer;
import org.apache.flink.table.store.file.utils.SerializationUtils;
import org.apache.flink.table.store.format.FieldStats;

public class BinaryTableStats {
    private final BinaryRowData min;
    private final BinaryRowData max;
    private final long[] nullCounts;
    @Nullable
    private FieldStats[] cacheArray;

    public BinaryTableStats(BinaryRowData min, BinaryRowData max, long[] nullCounts) {
        this(min, max, nullCounts, null);
    }

    public BinaryTableStats(BinaryRowData min, BinaryRowData max, long[] nullCounts, @Nullable FieldStats[] cacheArray) {
        this.min = min;
        this.max = max;
        this.nullCounts = nullCounts;
        this.cacheArray = cacheArray;
    }

    public FieldStats[] fields(FieldStatsArraySerializer converter) {
        return this.fields(converter, null);
    }

    public FieldStats[] fields(FieldStatsArraySerializer converter, @Nullable Long rowCount) {
        if (this.cacheArray == null) {
            this.cacheArray = converter.fromBinary(this, rowCount);
        }
        return this.cacheArray;
    }

    public BinaryRowData min() {
        return this.min;
    }

    public BinaryRowData max() {
        return this.max;
    }

    public long[] nullCounts() {
        return this.nullCounts;
    }

    public RowData toRowData() {
        return GenericRowData.of(SerializationUtils.serializeBinaryRow(this.min), SerializationUtils.serializeBinaryRow(this.max), new GenericArrayData(this.nullCounts));
    }

    public static BinaryTableStats fromRowData(RowData row) {
        return new BinaryTableStats(SerializationUtils.deserializeBinaryRow(row.getBinary(0)), SerializationUtils.deserializeBinaryRow(row.getBinary(1)), row.getArray(2).toLongArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryTableStats that = (BinaryTableStats)o;
        return Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max) && Arrays.equals(this.nullCounts, that.nullCounts);
    }

    public int hashCode() {
        int result = Objects.hash(this.min, this.max);
        result = 31 * result + Arrays.hashCode(this.nullCounts);
        return result;
    }
}

