/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util.concurrent;

import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;

@Internal
public final class NeverCompleteFuture
implements ScheduledFuture<Object> {
    private final Object lock = new Object();
    private final long delayMillis;
    private volatile boolean canceled;

    public NeverCompleteFuture(long delayMillis) {
        this.delayMillis = delayMillis;
    }

    @Override
    public long getDelay(@Nonnull TimeUnit unit) {
        return unit.convert(this.delayMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@Nonnull Delayed o) {
        long otherMillis = o.getDelay(TimeUnit.MILLISECONDS);
        return Long.compare(this.delayMillis, otherMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        Object object = this.lock;
        synchronized (object) {
            this.canceled = true;
            this.lock.notifyAll();
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.canceled) {
                this.lock.wait();
            }
        }
        throw new CancellationException();
    }

    @Override
    public Object get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.canceled) {
                unit.timedWait(this.lock, timeout);
            }
            if (this.canceled) {
                throw new CancellationException();
            }
            throw new TimeoutException();
        }
    }
}

