/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.file.io;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.store.file.KeyValue;
import org.apache.flink.table.store.file.io.DataFilePathFactory;
import org.apache.flink.table.store.file.io.KeyValueDataFileRecordReader;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.file.schema.KeyValueFieldsExtractor;
import org.apache.flink.table.store.file.schema.SchemaManager;
import org.apache.flink.table.store.file.schema.TableSchema;
import org.apache.flink.table.store.file.utils.BulkFormatMapping;
import org.apache.flink.table.store.file.utils.FileStorePathFactory;
import org.apache.flink.table.store.file.utils.RecordReader;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class KeyValueFileReaderFactory {
    private final SchemaManager schemaManager;
    private final long schemaId;
    private final RowType keyType;
    private final RowType valueType;
    private final BulkFormatMapping.BulkFormatMappingBuilder bulkFormatMappingBuilder;
    private final Map<Long, BulkFormatMapping> bulkFormatMappings;
    private final DataFilePathFactory pathFactory;

    private KeyValueFileReaderFactory(SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, BulkFormatMapping.BulkFormatMappingBuilder bulkFormatMappingBuilder, DataFilePathFactory pathFactory) {
        this.schemaManager = schemaManager;
        this.schemaId = schemaId;
        this.keyType = keyType;
        this.valueType = valueType;
        this.bulkFormatMappingBuilder = bulkFormatMappingBuilder;
        this.pathFactory = pathFactory;
        this.bulkFormatMappings = new HashMap<Long, BulkFormatMapping>();
    }

    public RecordReader<KeyValue> createRecordReader(long schemaId, String fileName, int level) throws IOException {
        BulkFormatMapping bulkFormatMapping = this.bulkFormatMappings.computeIfAbsent(schemaId, key -> {
            TableSchema tableSchema = this.schemaManager.schema(this.schemaId);
            TableSchema dataSchema = this.schemaManager.schema((long)key);
            return this.bulkFormatMappingBuilder.build(tableSchema, dataSchema);
        });
        return new KeyValueDataFileRecordReader(bulkFormatMapping.getReaderFactory(), this.pathFactory.toPath(fileName), this.keyType, this.valueType, level, bulkFormatMapping.getIndexMapping());
    }

    public static Builder builder(SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor) {
        return new Builder(schemaManager, schemaId, keyType, valueType, fileFormat, pathFactory, extractor);
    }

    public static class Builder {
        private final SchemaManager schemaManager;
        private final long schemaId;
        private final RowType keyType;
        private final RowType valueType;
        private final FileFormat fileFormat;
        private final FileStorePathFactory pathFactory;
        private final KeyValueFieldsExtractor extractor;
        private final int[][] fullKeyProjection;
        private int[][] keyProjection;
        private int[][] valueProjection;
        private RowType projectedKeyType;
        private RowType projectedValueType;

        private Builder(SchemaManager schemaManager, long schemaId, RowType keyType, RowType valueType, FileFormat fileFormat, FileStorePathFactory pathFactory, KeyValueFieldsExtractor extractor) {
            this.schemaManager = schemaManager;
            this.schemaId = schemaId;
            this.keyType = keyType;
            this.valueType = valueType;
            this.fileFormat = fileFormat;
            this.pathFactory = pathFactory;
            this.extractor = extractor;
            this.fullKeyProjection = Projection.range(0, keyType.getFieldCount()).toNestedIndexes();
            this.keyProjection = this.fullKeyProjection;
            this.valueProjection = Projection.range(0, valueType.getFieldCount()).toNestedIndexes();
            this.applyProjection();
        }

        public Builder withKeyProjection(int[][] projection) {
            this.keyProjection = projection;
            this.applyProjection();
            return this;
        }

        public Builder withValueProjection(int[][] projection) {
            this.valueProjection = projection;
            this.applyProjection();
            return this;
        }

        public KeyValueFileReaderFactory build(BinaryRowData partition, int bucket) {
            return this.build(partition, bucket, true, Collections.emptyList());
        }

        public KeyValueFileReaderFactory build(BinaryRowData partition, int bucket, boolean projectKeys, @Nullable List<Predicate> filters) {
            int[][] keyProjection = projectKeys ? this.keyProjection : this.fullKeyProjection;
            RowType projectedKeyType = projectKeys ? this.projectedKeyType : this.keyType;
            return new KeyValueFileReaderFactory(this.schemaManager, this.schemaId, projectedKeyType, this.projectedValueType, BulkFormatMapping.newBuilder(this.fileFormat, this.extractor, keyProjection, this.valueProjection, filters), this.pathFactory.createDataFilePathFactory(partition, bucket));
        }

        private void applyProjection() {
            this.projectedKeyType = (RowType)Projection.of(this.keyProjection).project((LogicalType)this.keyType);
            this.projectedValueType = (RowType)Projection.of(this.valueProjection).project((LogicalType)this.valueType);
        }
    }
}

