/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.orc;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.store.file.predicate.Predicate;
import org.apache.flink.table.store.format.FileFormat;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.store.format.orc.OrcFileStatsExtractor;
import org.apache.flink.table.store.format.orc.OrcInputFormatFactory;
import org.apache.flink.table.store.format.orc.OrcPredicateFunctionVisitor;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcFilters;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.OrcSplitReaderUtil;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.vector.RowDataVectorizer;
import org.apache.flink.table.store.shaded.org.apache.flink.orc.writer.OrcBulkWriterFactory;
import org.apache.flink.table.store.shaded.org.apache.orc.TypeDescription;
import org.apache.flink.table.store.utils.Projection;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;

public class OrcFileFormat
extends FileFormat {
    private final Properties orcProperties;
    private final org.apache.hadoop.conf.Configuration readerConf;
    private final org.apache.hadoop.conf.Configuration writerConf;

    public OrcFileFormat(Configuration formatOptions) {
        super("orc");
        this.orcProperties = OrcFileFormat.getOrcProperties((ReadableConfig)formatOptions);
        this.readerConf = new org.apache.hadoop.conf.Configuration();
        this.orcProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.readerConf.set(k.toString(), v.toString())));
        this.writerConf = new org.apache.hadoop.conf.Configuration();
    }

    @VisibleForTesting
    Properties orcProperties() {
        return this.orcProperties;
    }

    @Override
    public Optional<FileStatsExtractor> createStatsExtractor(RowType type) {
        return Optional.of(new OrcFileStatsExtractor(type));
    }

    @Override
    public BulkFormat<RowData, FileSourceSplit> createReaderFactory(RowType type, int[][] projection, @Nullable List<Predicate> filters) {
        ArrayList<OrcFilters.Predicate> orcPredicates = new ArrayList<OrcFilters.Predicate>();
        if (filters != null) {
            for (Predicate pred : filters) {
                Optional<OrcFilters.Predicate> orcPred = pred.visit(OrcPredicateFunctionVisitor.VISITOR);
                orcPred.ifPresent(orcPredicates::add);
            }
        }
        return OrcInputFormatFactory.create(this.readerConf, (RowType)OrcFileFormat.refineLogicalType((LogicalType)type), Projection.of(projection).toTopLevelIndexes(), orcPredicates);
    }

    @Override
    public BulkWriter.Factory<RowData> createWriterFactory(RowType type) {
        LogicalType refinedType = OrcFileFormat.refineLogicalType((LogicalType)type);
        LogicalType[] orcTypes = refinedType.getChildren().toArray(new LogicalType[0]);
        TypeDescription typeDescription = OrcSplitReaderUtil.logicalTypeToOrcType(refinedType);
        RowDataVectorizer vectorizer = new RowDataVectorizer(typeDescription.toString(), orcTypes);
        return new OrcBulkWriterFactory<RowData>(vectorizer, this.orcProperties, this.writerConf);
    }

    private static Properties getOrcProperties(ReadableConfig options) {
        Properties orcProperties = new Properties();
        Properties properties = new Properties();
        ((Configuration)options).addAllToProperties(properties);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> orcProperties.put("orc." + k, v)));
        return orcProperties;
    }

    private static LogicalType refineLogicalType(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BINARY: 
            case VARBINARY: {
                return DataTypes.BYTES().getLogicalType();
            }
            case ARRAY: {
                ArrayType arrayType = (ArrayType)type;
                return new ArrayType(arrayType.isNullable(), OrcFileFormat.refineLogicalType(arrayType.getElementType()));
            }
            case MAP: {
                MapType mapType = (MapType)type;
                return new MapType(OrcFileFormat.refineLogicalType(mapType.getKeyType()), OrcFileFormat.refineLogicalType(mapType.getValueType()));
            }
            case MULTISET: {
                MultisetType multisetType = (MultisetType)type;
                return new MapType(OrcFileFormat.refineLogicalType(multisetType.getElementType()), OrcFileFormat.refineLogicalType((LogicalType)new IntType(false)));
            }
            case ROW: {
                RowType rowType = (RowType)type;
                return new RowType(rowType.isNullable(), rowType.getFields().stream().map(f -> new RowType.RowField(f.getName(), OrcFileFormat.refineLogicalType(f.getType()), (String)f.getDescription().orElse(null))).collect(Collectors.toList()));
            }
        }
        return type;
    }
}

