/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.table.source.snapshot;

import org.apache.flink.table.store.file.Snapshot;
import org.apache.flink.table.store.file.operation.ScanKind;
import org.apache.flink.table.store.table.source.DataTableScan;
import org.apache.flink.table.store.table.source.snapshot.FollowUpScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionChangelogFollowUpScanner
implements FollowUpScanner {
    private static final Logger LOG = LoggerFactory.getLogger(CompactionChangelogFollowUpScanner.class);

    @Override
    public boolean shouldScanSnapshot(Snapshot snapshot) {
        if (snapshot.commitKind() == Snapshot.CommitKind.COMPACT) {
            return true;
        }
        LOG.debug("Next snapshot id {} is not COMPACT, but is {}, check next one.", (Object)snapshot.id(), (Object)snapshot.commitKind());
        return false;
    }

    @Override
    public DataTableScan.DataFilePlan getPlan(long snapshotId, DataTableScan scan) {
        return scan.withKind(ScanKind.CHANGELOG).withSnapshot(snapshotId).plan();
    }
}

